/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.commandsmonitor.UniqueTableSelectionManager;
import csbase.client.applications.commandsmonitor.events.DoubleClickEvent;
import csbase.client.applications.commandsmonitor.table.CommandsTableFactory;
import csbase.client.desktop.DesktopFrame;
import csbase.client.facilities.commandtable.AbstractCommandMonitoringTable;
import csbase.client.project.ProjectTreeAdapter;
import csbase.client.util.event.EventManager;
import csbase.client.util.gui.JMultiSplitPane;
import csbase.logic.CommonClientProject;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class TablesPanel
extends JScrollPane {
    private boolean running = false;
    protected UniqueTableSelectionManager selectionManager;
    private AbstractCommandMonitoringTable[] tables;

    public TablesPanel(List<String> tablesId, CommandsTableFactory tablesFactory, ApplicationRegistry appRegistry, EventManager eventManager) throws ApplicationException {
        if (tablesId.size() == 0) {
            throw new IllegalArgumentException("tablesId deve conter pelo menos um elemento.");
        }
        this.selectionManager = new UniqueTableSelectionManager(eventManager);
        this.setViewportView(this.createView(tablesId, tablesFactory, appRegistry, eventManager));
    }

    private JComponent createView(List<String> tablesId, CommandsTableFactory tablesFactory, ApplicationRegistry appRegistry, final EventManager eventManager) throws ApplicationException {
        this.setPreferredSize(new Dimension(850, 500));
        this.tables = new AbstractCommandMonitoringTable[tablesId.size()];
        Component[] innerPanels = new JPanel[tablesId.size()];
        int inx = 0;
        while (inx < tablesId.size()) {
            String aTableId = tablesId.get(inx);
            Title title = new Title(aTableId, appRegistry);
            this.tables[inx] = tablesFactory.createTable(aTableId);
            this.tables[inx].setPreferredScrollableViewportSize(new Dimension(800, 100));
            final AbstractCommandMonitoringTable currTable = this.tables[inx];
            currTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        eventManager.fireEvent(new DoubleClickEvent(currTable.getSelectedCommands()[0]));
                    }
                }
            });
            this.selectionManager.startManaging(this.tables[inx]);
            innerPanels[inx] = new JPanel(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.insets = new Insets(5, 5, 0, 5);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 2;
            constraints.fill = 1;
            constraints.anchor = 17;
            ((Container)innerPanels[inx]).add(title, constraints);
            constraints = new GridBagConstraints();
            constraints.insets = new Insets(5, 5, 5, 5);
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 2;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            constraints.anchor = 17;
            ((Container)innerPanels[inx]).add(new JScrollPane((Component)((Object)this.tables[inx])), constraints);
            ++inx;
        }
        if (innerPanels.length == 1) {
            return innerPanels[0];
        }
        boolean split = false;
        JMultiSplitPane pane = new JMultiSplitPane(0, false, innerPanels);
        pane.setOneTouchExpandable(true);
        return pane;
    }

    public void start() {
        if (!this.running) {
            AbstractCommandMonitoringTable[] abstractCommandMonitoringTableArray = this.tables;
            int n = this.tables.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractCommandMonitoringTable aTable = abstractCommandMonitoringTableArray[n2];
                aTable.start();
                ++n2;
            }
        }
        this.running = true;
    }

    public void stop() {
        AbstractCommandMonitoringTable[] abstractCommandMonitoringTableArray = this.tables;
        int n = this.tables.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractCommandMonitoringTable aTable = abstractCommandMonitoringTableArray[n2];
            aTable.stop();
            ++n2;
        }
        this.running = false;
    }

    class Title
    extends JLabel {
        private static final String TITLE_FLAG_PROJECT_NAME = "${project.name}";
        private static final String TITLE_FLAG_PROJECT_NAME_REGEX = "\\$\\{project\\.name\\}";
        private static final String TITLE_KEY = "table.%s.title";
        private static final String NULL_PROJECT_TITLE_KEY = "table.%s.title.project.none";

        public Title(String tableId, ApplicationRegistry appRegistry) {
            final String title = appRegistry.getString(String.format(TITLE_KEY, tableId));
            if (title.contains(TITLE_FLAG_PROJECT_NAME)) {
                String nullProjectKey = String.format(NULL_PROJECT_TITLE_KEY, tableId);
                final String nullProjectTitle = appRegistry.getResourceBundle().containsKey(nullProjectKey) ? appRegistry.getString(nullProjectKey) : title.replaceAll(TITLE_FLAG_PROJECT_NAME_REGEX, "");
                CommonClientProject project = DesktopFrame.getInstance().getProject();
                this.setText(project == null ? nullProjectTitle : title.replaceAll(TITLE_FLAG_PROJECT_NAME_REGEX, project.getName()));
                DesktopFrame.getInstance().getTree().addProjectTreeListener(new ProjectTreeAdapter(){

                    @Override
                    public void projectChanged(CommonClientProject project) {
                        Title.this.setText(project == null ? nullProjectTitle : title.replaceAll(Title.TITLE_FLAG_PROJECT_NAME_REGEX, project.getName()));
                    }
                });
            } else {
                this.setText(title);
            }
        }
    }
}

