/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor.actions;

import csbase.client.applications.AbstractSimpleApplicationAction;
import csbase.client.applications.commandsmonitor.CommandsMonitor;
import csbase.client.applications.commandsmonitor.events.SelectionChangedEvent;
import csbase.client.util.event.EventListener;
import csbase.logic.CommandInfo;
import javax.swing.ImageIcon;

public abstract class AbstractCommandsAction
extends AbstractSimpleApplicationAction<CommandsMonitor> {
    private boolean acceptMultipleCommands;
    private CommandInfo[] commands;

    protected AbstractCommandsAction(CommandsMonitor application, boolean acceptMultipleCommands, ImageIcon icon) {
        super(application, icon);
        this.initialize(acceptMultipleCommands);
    }

    protected AbstractCommandsAction(CommandsMonitor application, boolean acceptMultipleCommands) {
        super(application);
        this.initialize(acceptMultipleCommands);
    }

    protected abstract boolean accept(CommandInfo var1);

    protected CommandInfo[] getSelectedCommands() {
        return this.commands;
    }

    protected CommandInfo getSelectedCommand() {
        return this.commands[0];
    }

    private void initialize(boolean acceptMultipleCommands) {
        this.acceptMultipleCommands = acceptMultipleCommands;
        this.setEnabled(false);
        ((CommandsMonitor)this.getApplication()).addSelectionChangedListener(new EventListener<SelectionChangedEvent>(){

            @Override
            public void eventFired(SelectionChangedEvent event) {
                AbstractCommandsAction.this.setEnable(event.getSelection());
            }
        });
    }

    private void setEnable(CommandInfo[] commands) {
        if (commands == null || commands.length == 0) {
            this.setEnabled(false);
        } else if (!this.acceptMultipleCommands && 1 < commands.length) {
            this.setEnabled(false);
        } else {
            CommandInfo[] commandInfoArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                CommandInfo aCommand = commandInfoArray[n2];
                if (!this.accept(aCommand)) {
                    this.setEnabled(false);
                    return;
                }
                ++n2;
            }
            this.commands = commands;
            this.setEnabled(true);
        }
    }
}

