/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor.actions;

import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.commandsmonitor.CommandsMonitor;
import csbase.client.applications.commandsmonitor.actions.AbstractCommandsAction;
import csbase.client.desktop.RemoteTask;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.Arrays;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class RemoveCommandsAction
extends AbstractCommandsAction {
    public RemoveCommandsAction(CommandsMonitor application) {
        super(application, true, ApplicationImages.ICON_DELETE_16);
    }

    @Override
    protected boolean accept(CommandInfo command) {
        return command.getStatus() == CommandStatus.FINISHED || command.getStatus() == CommandStatus.SYSTEM_FAILURE;
    }

    @Override
    protected void handleActionPerformed(ActionEvent ae) throws Exception {
        this.removeCommands(this.getSelectedCommands());
    }

    private boolean removeCommands(CommandInfo[] commands) {
        if (!this.warnRemoveCommand()) {
            return false;
        }
        if (commands.length == 0) {
            return true;
        }
        String taskTitle = this.getString("RemoveCommandsAction.task.commands.remove.title", new Object[0]);
        String taskMessage = this.getString("RemoveCommandsAction.task.commands.remove.message", commands.length);
        class RemoveCommandTask
        extends RemoteTask<boolean[]> {
            private final /* synthetic */ CommandInfo[] val$commands;

            RemoveCommandTask(CommandInfo[] commandInfoArray) {
                this.val$commands = commandInfoArray;
            }

            protected void performTask() throws RemoteException {
                this.setResult(CommandsCache.getInstance().removeCommands(Arrays.asList(this.val$commands)));
            }
        }
        RemoveCommandTask task = new RemoveCommandTask(commands);
        ApplicationFrame frame = ((CommandsMonitor)this.getApplication()).getApplicationFrame();
        if (!task.execute(frame, taskTitle, taskMessage)) {
            return false;
        }
        boolean[] cmdsResult = (boolean[])task.getResult();
        boolean error = false;
        boolean[] blArray = cmdsResult;
        int n = cmdsResult.length;
        int n2 = 0;
        while (n2 < n) {
            boolean cmdResult = blArray[n2];
            error |= !cmdResult;
            ++n2;
        }
        if (error) {
            String errorMessage = this.getString("RemoveCommandsAction.task.commands.remove.error", commands.length);
            ((CommandsMonitor)this.getApplication()).showError(errorMessage);
        }
        return !error;
    }

    private boolean warnRemoveCommand() {
        String message = this.getString("RemoveCommandsAction.task.commands.remove.confirmation.query", new Object[0]);
        ApplicationFrame frame = ((CommandsMonitor)this.getApplication()).getApplicationFrame();
        String title = frame.getTitle();
        Object[] options = new String[]{LNG.get((String)"UTIL_YES"), LNG.get((String)"UTIL_NO")};
        int option = StandardDialogs.showOptionDialog((Component)frame, (String)title, (Object)message, (Object[])options);
        switch (option) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        String errorMessage = this.getString("RemoveCommandsAction.task.commands.remove.confirmation.error", option);
        throw new IllegalStateException(errorMessage);
    }
}

