/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor.table.column;

import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.commandsmonitor.table.column.AbstractCommandsTableColumn;
import csbase.client.desktop.RemoteTask;
import csbase.logic.CommandInfo;
import csbase.logic.Priority;
import csbase.logic.User;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class PriorityColumn
extends AbstractCommandsTableColumn {
    public PriorityColumn(String id, ApplicationRegistry appRegistry) {
        super(Priority.class, id, appRegistry, User.getLoggedUser().isAdmin());
    }

    @Override
    public Object getValue(CommandInfo cmd) {
        return cmd.getPriority();
    }

    @Override
    public void setValue(final CommandInfo cmd, Object value) {
        Priority previousPriority = cmd.getPriority();
        String priorityName = value.toString();
        cmd.setPriority(this.getPriority(priorityName));
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            protected void performTask() throws RemoteException {
                this.setResult(CommandsCache.getInstance().updatePriority(cmd));
            }
        };
        String taskTitle = this.getGenericString("task.command.update.title", new Object[0]);
        String taskMessage = this.getGenericString("task.command.update.message", new Object[0]);
        boolean success = task.execute(null, taskTitle, taskMessage);
        if (!success || !((Boolean)task.getResult()).booleanValue()) {
            cmd.setPriority(previousPriority);
        }
    }

    @Override
    public TableCellRenderer createTableCellRenderer() {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)comp;
                renderer.setText(PriorityColumn.this.getPriorityName((Priority)value));
                if (PriorityColumn.this.isColumnEditable()) {
                    renderer.setIcon(ApplicationImages.ICON_EDITABLE_TABLE_CELL_14);
                }
                return this;
            }
        };
    }

    @Override
    public TableCellEditor createTableCellEditor() {
        String[] items = new String[Priority.values().length];
        int inx = 0;
        while (inx < items.length) {
            items[inx] = this.getPriorityName(Priority.values()[inx]);
            ++inx;
        }
        JComboBox<String> comboBox = new JComboBox<String>(items);
        return new DefaultCellEditor(comboBox);
    }

    private Priority getPriority(String name) {
        Priority[] priorityArray = Priority.values();
        int n = priorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Priority aPriority = priorityArray[n2];
            if (this.getPriorityName(aPriority).equals(name)) {
                return aPriority;
            }
            ++n2;
        }
        return Priority.MEDIUM;
    }

    private String getPriorityName(Priority priority) {
        String keySufix = String.format("value.%s", priority.name().toLowerCase());
        return this.getString(keySufix, new Object[0]);
    }
}

