/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.csvviewer;

import csbase.client.applications.ApplicationAboutAction;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationProject;
import csbase.client.applications.csvviewer.actions.CloseCSVAction;
import csbase.client.applications.csvviewer.actions.HeaderConfigurationAction;
import csbase.client.applications.csvviewer.actions.NewCSVAction;
import csbase.client.applications.csvviewer.actions.OpenCSVAction;
import csbase.client.applications.csvviewer.actions.OpenLocalCSVAction;
import csbase.client.applications.csvviewer.actions.SaveCSVAction;
import csbase.client.applications.csvviewer.actions.SaveCSVAsAction;
import csbase.client.applications.csvviewer.actions.SaveLocalCSVAction;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeAdapter;
import csbase.client.util.csvpanel.CSVExceptionNotification;
import csbase.client.util.csvpanel.CSVPanel;
import csbase.client.util.csvpanel.CSVTableModelNotification;
import csbase.client.util.event.EventListener;
import csbase.client.util.filechooser.ClientProjectFileChooserUtil;
import csbase.logic.ClientFile;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import java.awt.Component;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import tecgraf.javautils.gui.StandardDialogs;

public class CSVViewer
extends ApplicationProject {
    private final CSVPanel csvPanel = new CSVPanel();
    private boolean contentChanged;
    private boolean projectEnabled;
    private NewCSVAction newCSVAction;
    private OpenCSVAction openCSVAction;
    private OpenLocalCSVAction openLocalCSVAction;
    private SaveCSVAction saveCSVAction;
    private SaveCSVAsAction saveCSVAsAction;
    private SaveLocalCSVAction saveLocalCSVAction;
    private CloseCSVAction closeCSVAction;
    private HeaderConfigurationAction headerConfigurationAction;
    private ApplicationExitAction applicationExitAction;
    private ApplicationAboutAction applicationAboutAction;
    private ProjectTreeAdapter projectTreeAdapter;
    public static final int DEFAULT_SIZE = 5;

    public CSVViewer(String id) {
        super(id);
        this.csvPanel.addExceptionListener(new EventListener<CSVExceptionNotification>(){

            @Override
            public void eventFired(CSVExceptionNotification event) {
                CSVViewer.this.getApplicationFrame().getStatusBar().setError(event.getMessage(), 10);
            }
        });
        this.csvPanel.addCSVTableModelListener(new EventListener<CSVTableModelNotification>(){

            @Override
            public void eventFired(CSVTableModelNotification event) {
                CSVViewer.this.setContentChanged(true);
            }
        });
        this.buildFrame(this.csvPanel);
        this.handleOpenProject();
        this.newCSV(5, 5);
        this.setContentChanged(false);
    }

    public final void openFile(ClientFile file) {
        if (this.closeFile()) {
            this.getApplicationFrame().getStatusBar().clearStatus();
            this.csvPanel.openFile(file, true);
            String type = file.getType();
            if (type != null && type.equals("MFLX")) {
                this.csvPanel.setNumRowsAsHeader(3);
            }
            this.setContentChanged(false);
        }
    }

    public final void saveFile(ClientFile file) {
        this.getApplicationFrame().getStatusBar().clearStatus();
        ClientFile selectedFile = file;
        if (selectedFile == null) {
            List<String> fileTypes = this.getFileTypes();
            ClientProjectFileChooserUtil.OperationResult result = ClientProjectFileChooserUtil.browseSingleFileInSaveMode(this, fileTypes, fileTypes.get(0), true, true);
            if (result == null) {
                return;
            }
            selectedFile = result.getClientProjectFile();
            if (selectedFile == null) {
                return;
            }
        }
        this.csvPanel.saveFile(selectedFile);
        this.setContentChanged(false);
    }

    private void setContentChanged(boolean contentChanged) {
        this.contentChanged = contentChanged;
        this.updateActions();
        this.updateTitle();
    }

    @Override
    public void sendMessage(String name, Object value, String senderId) {
        if (value == null) {
            return;
        }
        if (name.equals("PROJECT_FILE")) {
            ClientProjectFile file = (ClientProjectFile)value;
            this.openFile((ClientFile)file);
        }
    }

    @Override
    public void killApplication() {
        if (this.closeFile()) {
            DesktopFrame desktopFrame = DesktopFrame.getInstance();
            desktopFrame.getTree().removeProjectTreeListener(this.projectTreeAdapter);
        }
    }

    private boolean confirmFileClosing() {
        if (this.contentChanged) {
            int result = StandardDialogs.showYesNoCancelDialog((Component)this.getApplicationFrame(), (String)this.getName(), (Object)this.getString("confirmFileClosing.message"));
            switch (result) {
                case 0: {
                    this.saveFile(this.getFile());
                    return true;
                }
                case -1: 
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected boolean userCanKillApplication() {
        return this.closeFile();
    }

    private void buildFrame(CSVPanel panel) {
        ApplicationFrame mainFrame = this.getApplicationFrame();
        this.createActions();
        mainFrame.getContentPane().add((Component)this.createToolBar(), "North");
        mainFrame.getContentPane().add((Component)panel, "Center");
        mainFrame.setJMenuBar(this.createMenuBar());
        mainFrame.getStatusBar().showStatusBar();
        mainFrame.setSize(800, 600);
    }

    private boolean allowLocalFiles() {
        String propName = "allow.local.files";
        boolean flag = this.getBooleanSpecificProperty("allow.local.files", false);
        return flag;
    }

    public void createActions() {
        this.newCSVAction = new NewCSVAction(this);
        this.openCSVAction = new OpenCSVAction(this);
        this.openLocalCSVAction = new OpenLocalCSVAction(this);
        this.saveLocalCSVAction = new SaveLocalCSVAction(this);
        this.saveCSVAsAction = new SaveCSVAsAction(this);
        this.saveCSVAction = new SaveCSVAction(this);
        this.closeCSVAction = new CloseCSVAction(this);
        this.headerConfigurationAction = new HeaderConfigurationAction(this);
        this.applicationExitAction = new ApplicationExitAction(this);
        this.applicationAboutAction = new ApplicationAboutAction(this);
    }

    public JMenuBar createMenuBar() {
        JMenuBar menu = new JMenuBar();
        JMenu fileMenu = new JMenu(this.getString("file.menu"));
        fileMenu.add(this.newCSVAction);
        fileMenu.add(this.openCSVAction);
        boolean allowLocalFiles = this.allowLocalFiles();
        if (allowLocalFiles) {
            fileMenu.add(this.openLocalCSVAction);
        }
        fileMenu.add(this.saveCSVAction);
        fileMenu.add(this.saveCSVAsAction);
        if (allowLocalFiles) {
            fileMenu.add(this.saveLocalCSVAction);
        }
        fileMenu.add(this.closeCSVAction);
        fileMenu.addSeparator();
        fileMenu.add(this.applicationExitAction);
        JMenu optionsMenu = new JMenu(this.getString("options.menu"));
        optionsMenu.add(this.headerConfigurationAction);
        JMenu helpMenu = new JMenu(this.getString("help.menu"));
        helpMenu.add(this.applicationAboutAction);
        menu.add(fileMenu);
        menu.add(optionsMenu);
        menu.add(helpMenu);
        return menu;
    }

    private final JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(this.newCSVAction);
        toolBar.add(this.openCSVAction);
        if (this.allowLocalFiles()) {
            toolBar.add(this.openLocalCSVAction);
        }
        toolBar.add(this.saveCSVAction);
        toolBar.add(this.saveCSVAsAction);
        toolBar.addSeparator();
        toolBar.add(this.applicationAboutAction);
        return toolBar;
    }

    public boolean closeFile() {
        boolean confirmed = this.confirmFileClosing();
        if (confirmed) {
            this.getApplicationFrame().getStatusBar().clearStatus();
            this.csvPanel.closeFile();
            this.setContentChanged(false);
        }
        return confirmed;
    }

    private void updateActions() {
        this.openCSVAction.setEnabled(this.projectEnabled);
        this.saveCSVAsAction.setEnabled(this.projectEnabled);
        this.saveCSVAction.setEnabled(this.projectEnabled && this.contentChanged);
    }

    public ClientFile getFile() {
        return this.csvPanel.getFile();
    }

    private void updateTitle() {
        ClientFile file = this.getFile();
        String title = this.getName();
        if (file != null) {
            title = String.valueOf(title) + " - " + file.getStringPath();
            if (!this.csvPanel.isEditable()) {
                title = String.valueOf(title) + " [" + this.getString("readonly.tag") + "]";
            }
        }
        if (this.contentChanged) {
            title = String.valueOf(title) + "*";
        }
        this.getApplicationFrame().setTitle(title);
    }

    private void handleOpenProject() {
        this.projectTreeAdapter = new ProjectTreeAdapter(){

            @Override
            public void projectChanged(CommonClientProject proj) {
                if (proj == null) {
                    CSVViewer.this.setProjectEnabled(false);
                } else {
                    CSVViewer.this.setProjectEnabled(true);
                }
            }
        };
        DesktopFrame desktopFrame = DesktopFrame.getInstance();
        ProjectTree projectTree = desktopFrame.getTree();
        projectTree.addProjectTreeListener(this.projectTreeAdapter);
        if (projectTree.getProject() == null) {
            this.setProjectEnabled(false);
        } else {
            this.setProjectEnabled(true);
        }
    }

    private void setProjectEnabled(boolean projectEnabled) {
        this.projectEnabled = projectEnabled;
        this.updateActions();
    }

    public void newCSV(int rows, int cols) {
        this.csvPanel.closeFile();
        this.csvPanel.setData(new String[rows][cols], true);
        this.setContentChanged(true);
    }

    public void setNumRowsAsHeader(int lines) {
        this.csvPanel.setNumRowsAsHeader(lines);
    }

    public int getNumRowsAsHeader() {
        return this.csvPanel.getNumRowsAsHeader();
    }
}

