/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.desktoplauncher;

import csbase.client.Client;
import csbase.client.applications.desktoplauncher.DesktopLauncher;
import csbase.client.externalresources.ExternalResources;
import csbase.client.openbus.OpenBusAccessPoint;
import csbase.client.openbus.OpenBusTask;
import csbase.logic.openbus.OpenBusLoginToken;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.OpenURLServiceInterface;
import java.net.URL;
import java.util.Locale;
import tecgraf.javautils.core.lng.LNG;

final class DesktopLauncherTask
extends OpenBusTask<Void> {
    private final DesktopLauncher application;
    private String systemLabel;

    @Override
    protected final String getString(String key) {
        String prefix = ((Object)((Object)this)).getClass().getSimpleName();
        return this.application.getString(String.valueOf(prefix) + "." + key);
    }

    protected void performTask() throws Exception {
        OpenBusAccessPoint oap = OpenBusAccessPoint.getInstance();
        oap.init();
        oap.initSession();
        OpenBusLoginToken token = oap.getLoginToken();
        Locale locale = LNG.getLocale();
        OpenURLServiceInterface service = ClientRemoteLocator.openURLService;
        Client client = Client.getInstance();
        String myClientId = client.getClientInstanceId();
        String sonId = this.application.getSonId();
        boolean startVisible = this.application.isChildDesktopInitiallyVisible();
        URL url = service.getSystemURL(locale, token, this.systemLabel, myClientId, sonId, startVisible);
        if (url == null) {
            String key = "null.url.error";
            String err = this.getString("null.url.error");
            throw new Exception(err);
        }
        ExternalResources externalResources = ExternalResources.getInstance();
        boolean launched = externalResources.showDocument(url);
        if (!launched) {
            String key = "launch.error";
            String err = this.getString("launch.error");
            throw new Exception(err);
        }
    }

    DesktopLauncherTask(DesktopLauncher application, String systemLabel) {
        this.systemLabel = systemLabel;
        this.application = application;
    }
}

