/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.diskmonitor;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationAboutAction;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.diskmonitor.DiskMonitorThread;
import csbase.client.applications.diskmonitor.actions.DiskMonitorChangeAreaAction;
import csbase.client.applications.diskmonitor.actions.DiskMonitorRefreshAction;
import csbase.client.applications.diskmonitor.panels.DiskMonitorPieChartPanel;
import csbase.client.remote.srvproxies.DiskUsageProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.diskusageservice.DiskOccupation;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.DiskUsageServiceInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class DiskMonitor
extends Application {
    private final DiskMonitorThread thread;
    private final DiskMonitorPieChartPanel pieChartPanel = new DiskMonitorPieChartPanel(this);
    private final List<String> areasIds;
    private String currentAreaId;

    public DiskMonitor(String id) {
        super(id);
        this.thread = new DiskMonitorThread(this);
        this.areasIds = DiskUsageProxy.getAllAreasIds();
        Collections.unmodifiableList(this.areasIds);
        this.currentAreaId = this.areasIds.get(0);
        ApplicationFrame mainFrame = this.getApplicationFrame();
        mainFrame.setJMenuBar(this.buildMenuBar());
        this.mountMainPanel(((JFrame)mainFrame).getContentPane());
        mainFrame.pack();
        this.thread.start();
    }

    private JMenu buildHelpMenu() {
        JMenu helpMenu = new JMenu(this.getMenuString("help"));
        helpMenu.add(new ApplicationAboutAction(this));
        return helpMenu;
    }

    private JMenu buildAreasMenu() {
        JMenu menu = new JMenu(this.getMenuString("areas"));
        int[] keys = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57};
        int i = 0;
        ButtonGroup grp = new ButtonGroup();
        boolean checked = false;
        for (String id : this.areasIds) {
            DiskMonitorChangeAreaAction ac = new DiskMonitorChangeAreaAction(this, id);
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(ac);
            grp.add(item);
            menu.add(item);
            if (!checked) {
                item.setSelected(true);
                checked = true;
            }
            if (i < keys.length) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(keys[i], 128);
                item.setAccelerator(keyStroke);
            }
            ++i;
        }
        return menu;
    }

    private JMenuBar buildMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu optionsMenu = this.buildOptionsMenu();
        JMenu areasMenu = this.buildAreasMenu();
        JMenu helpMenu = this.buildHelpMenu();
        menuBar.add(optionsMenu);
        menuBar.add(areasMenu);
        menuBar.add(helpMenu);
        return menuBar;
    }

    private JMenu buildOptionsMenu() {
        JMenu menu = new JMenu(this.getMenuString("options"));
        menu.add(new DiskMonitorRefreshAction(this));
        menu.addSeparator();
        menu.add(new ApplicationExitAction(this));
        return menu;
    }

    private String getMenuString(String tag) {
        String prefix = this.getClass().getSimpleName();
        return this.getString(String.valueOf(prefix) + "." + tag + ".menu");
    }

    public final void handleException(Exception e) {
        ApplicationFrame frame = this.getApplicationFrame();
        String title = this.getName();
        String msg = e.getMessage();
        StandardErrorDialogs.showErrorDialog(frame, title, msg, e);
    }

    @Override
    public void killApplication() {
        if (this.thread != null) {
            this.thread.killThread();
        }
    }

    private void mountMainPanel(Container container) {
        container.setLayout(new BorderLayout());
        container.add((Component)this.pieChartPanel, "Center");
    }

    public void refresh() {
        boolean isEDT = SwingThreadDispatcher.isEventDispatchThread();
        if (isEDT) {
            DiskOccupation occ = DiskUsageProxy.getAreaOccupation(this.currentAreaId);
            this.updateChartWithEDT(this.currentAreaId, occ);
        } else {
            DiskOccupation occ;
            DiskUsageServiceInterface service = ClientRemoteLocator.diskUsageService;
            try {
                occ = service.getAreaOccupation(this.currentAreaId);
            }
            catch (RemoteException re) {
                occ = null;
            }
            final DiskOccupation auxOcc = occ;
            SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    DiskMonitor.this.updateChartWithEDT(DiskMonitor.this.currentAreaId, auxOcc);
                }
            });
        }
    }

    private void updateChartWithEDT(String id, DiskOccupation occupation) {
        if (this.currentAreaId == null) {
            this.pieChartPanel.resetChart(id);
        }
        this.pieChartPanel.updateChart(this.currentAreaId, occupation);
    }

    public final void setCurrentAreaId(String id) {
        this.currentAreaId = id;
    }

    @Override
    protected boolean userCanKillApplication() {
        return true;
    }
}

