/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.fileexchanger.logic;

import csbase.client.applications.fileexchanger.FileExchangerUI;
import csbase.client.applications.fileexchanger.exceptions.ChildInvalidNameException;
import csbase.client.applications.fileexchanger.logic.Exchange;
import csbase.client.applications.fileexchanger.logic.ExchangeMode;
import csbase.client.applications.fileexchanger.logic.ExchangeThread;
import csbase.client.project.tasks.GetChildFromNameTask;
import csbase.client.util.ClientUtilities;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileChannelLoadListener;
import csbase.logic.ProjectFileType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import tecgraf.javautils.core.io.FileUtils;

public class ExchangeImportThread
extends ExchangeThread {
    @Override
    public void run() {
        Exchange exchange = null;
        File localFile = null;
        ClientProjectFile remoteFile = null;
        try {
            exchange = this.getExchange();
            localFile = exchange.getLocalFile();
            ClientProjectFile remoteDir = exchange.getRemoteDir();
            remoteFile = exchange.getRemoteFile();
            if (remoteFile == null) {
                remoteFile = this.createRemoteFile(localFile, remoteDir, remoteFile);
            }
            exchange.setRemoteFile(remoteFile);
            this.importFile(localFile, remoteFile);
        }
        catch (FileNotFoundException e) {
            IOException io = null;
            try {
                Object[] args = new String[]{localFile.getAbsolutePath()};
                String msg = FileExchangerUI.getString("ExchangeImportThread.FileNotFoundException.msg", args);
                io = new IOException(msg, e);
                if (remoteFile != null && remoteFile.isOpen()) {
                    remoteFile.close(true);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            exchange.signalEnded(io);
            return;
        }
        catch (RemoteException e) {
            RemoteException re = null;
            try {
                String tag = "FileExchanger.RemoteException.msg";
                String msg = FileExchangerUI.getString("FileExchanger.RemoteException.msg");
                re = new RemoteException(msg, e);
                if (remoteFile != null && remoteFile.isOpen()) {
                    remoteFile.close(true);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            exchange.signalEnded(re);
            return;
        }
        catch (IOException e) {
            IOException io = null;
            try {
                Object[] args = new String[]{localFile.getAbsolutePath()};
                String msg = FileExchangerUI.getString("ExchangeImportThread.IOException.msg", args);
                io = new IOException(msg, e);
                if (remoteFile != null && remoteFile.isOpen()) {
                    remoteFile.close(true);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            exchange.signalEnded(io);
            return;
        }
        catch (Exception e) {
            try {
                if (remoteFile != null && remoteFile.isOpen()) {
                    remoteFile.close(true);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            exchange.signalEnded(e);
            return;
        }
        exchange.signalEnded(null);
    }

    private void importFile(File localFile, ClientProjectFile remoteFile) throws Exception {
        if (localFile.isDirectory()) {
            boolean childInvalidName = false;
            File[] fileArray = localFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                String childName = child.getName();
                if (!childName.matches("^..*csbase$") && !childName.matches("^..*csbase_description$")) {
                    if (ClientUtilities.isValidFileName(childName)) {
                        ClientProjectFile remoteChild = GetChildFromNameTask.runTask(remoteFile, childName);
                        if (remoteChild == null) {
                            remoteChild = this.createRemoteFile(child, remoteFile, null);
                        }
                        try {
                            this.importFile(child, remoteChild);
                        }
                        catch (ChildInvalidNameException e) {
                            childInvalidName = true;
                        }
                    } else {
                        childInvalidName = true;
                    }
                }
                ++n2;
            }
            if (childInvalidName) {
                throw new ChildInvalidNameException(localFile.getName());
            }
        } else {
            Exchange exchange = this.getExchange();
            ExchangeMode transferMode = exchange.getTransferMode();
            switch (transferMode) {
                case STREAM: {
                    this.importAsStream(localFile, remoteFile);
                    break;
                }
                case OPERATION: {
                    this.importAsUpload(localFile, remoteFile);
                }
            }
        }
    }

    private ClientProjectFile createRemoteFile(File localFile, ClientProjectFile remoteDir, ClientProjectFile remoteFile) throws RemoteException {
        if (remoteFile != null) {
            return remoteFile;
        }
        CommonClientProject project = this.getExchange().getProject();
        String fileName = localFile.getName();
        ClientProjectFile newFile = null;
        if (localFile.isDirectory()) {
            newFile = project.createAndWaitForDirectory(remoteDir, fileName);
        } else if (ClientUtilities.isValidFileName(fileName)) {
            String fileExtension = FileUtils.getFileExtension((String)fileName);
            ProjectFileType pft = ProjectFileType.getProjectFileTypeFromExtension((String)fileExtension);
            String fileType = pft == null ? "" : pft.getCode();
            newFile = project.createAndWaitForFile(remoteDir, fileName, fileType);
        }
        return newFile;
    }

    private void importAsStream(File localFile, ClientProjectFile remoteFile) throws IOException {
        Exchange exchange = this.getExchange();
        int bufferSize = exchange.getBlockSize().getSize();
        OutputStream prjStream = remoteFile.getOutputStream();
        BufferedOutputStream out = new BufferedOutputStream(prjStream);
        FileInputStream fileStream = new FileInputStream(localFile);
        BufferedInputStream in = new BufferedInputStream(fileStream);
        byte[] buffer = new byte[bufferSize];
        int len = 0;
        while ((len = in.read(buffer)) > 0) {
            exchange.addCurrentTransferSize(len);
            out.write(buffer, 0, len);
        }
        out.flush();
        out.close();
        in.close();
    }

    private void importAsUpload(File localFile, ClientProjectFile remoteFile) throws IOException {
        final Exchange exchange = this.getExchange();
        int chunkSize = exchange.getBlockSize().getSize();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(localFile));
        remoteFile.upload((InputStream)in, (long)chunkSize, new ProjectFileChannelLoadListener(){

            public void transferedBytes(long currentSize, long numBytes) {
                exchange.addCurrentTransferSize(numBytes);
            }
        });
        ((InputStream)in).close();
    }

    public ExchangeImportThread(Exchange exchange) {
        super(exchange);
    }
}

