/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.fileexchanger.panels.detailpanel;

import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.logic.Exchange;
import csbase.client.applications.fileexchanger.panels.core.FileExchangerPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.GBC;

public class DetailPanel
extends FileExchangerPanel {
    private final JTextField rateText = new JTextField();
    private final JTextField sizeText = new JTextField();
    private final JFreeChart jchart;
    private final ChartPanel chartPanel;
    private final XYSeriesCollection internalSeriesCollection = new XYSeriesCollection();

    public void updateData(ArrayList<Exchange> exchanges) {
        this.updateDataTexts(exchanges);
        this.updateDataGraphs(exchanges);
    }

    private void updateDataGraphs(ArrayList<Exchange> exchanges) {
        this.internalSeriesCollection.removeAllSeries();
        for (Exchange exchange : exchanges) {
            String label = exchange.getLabel();
            XYSeries series = new XYSeries((Comparable)((Object)label), false, true);
            ArrayList<Point2D.Double> points = exchange.getPoints();
            if (points == null) continue;
            int size = points.size();
            int idx = 0;
            while (idx < size - 1) {
                Point2D.Double pt1 = points.get(idx);
                Point2D.Double pt2 = points.get(idx + 1);
                double dt = pt2.x - pt1.x;
                double ds = pt2.y - pt1.y;
                double rate = ds / dt;
                double t = (pt1.x + pt2.x) / 2.0;
                series.add(t, rate);
                ++idx;
            }
            this.internalSeriesCollection.addSeries(series);
        }
    }

    private void updateDataTexts(ArrayList<Exchange> exchanges) {
        if (exchanges == null || exchanges.size() == 0) {
            this.rateText.setText(null);
            this.sizeText.setText(null);
            return;
        }
        double rateAvg = 0.0;
        long sizeTotal = 0L;
        for (Exchange exchange : exchanges) {
            rateAvg += exchange.getGlobalTransferRateMbSec();
            sizeTotal += exchange.getTotalTransferSize();
        }
        this.rateText.setText(String.valueOf(String.format("%.2f", rateAvg /= (double)exchanges.size())) + " Mb/s");
        this.sizeText.setText(FormatUtils.formatSize((long)sizeTotal, (int)2));
    }

    private JPanel buildTextPanel() {
        this.rateText.setEditable(false);
        this.sizeText.setEditable(false);
        Dimension preferredSize = new Dimension(170, 22);
        this.rateText.setHorizontalAlignment(4);
        this.sizeText.setHorizontalAlignment(4);
        this.rateText.setPreferredSize(preferredSize);
        this.sizeText.setPreferredSize(preferredSize);
        JLabel rateLabel = new JLabel(this.getString("DetailPanel.avg.rate.label"));
        JLabel sizeLabel = new JLabel(this.getString("DetailPanel.total.size.label"));
        int M = 7;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)rateLabel, new GBC(0, 0).none().west().insets(7, 7, 0, 7));
        panel.add((Component)this.rateText, new GBC(0, 1).none().west().insets(0, 7, 0, 7));
        panel.add((Component)sizeLabel, new GBC(0, 2).none().west().insets(7, 7, 0, 7));
        panel.add((Component)this.sizeText, new GBC(0, 3).none().west().insets(0, 7, 7, 7));
        return panel;
    }

    public DetailPanel(FileExchanger fileExchanger) {
        super(fileExchanger);
        NumberAxis xAxis = new NumberAxis();
        NumberAxis yAxis = new NumberAxis();
        xAxis.setAutoRange(true);
        yAxis.setAutoRange(true);
        xAxis.setAutoRangeIncludesZero(false);
        yAxis.setAutoRangeIncludesZero(true);
        xAxis.setAutoRangeStickyZero(true);
        yAxis.setAutoRangeStickyZero(true);
        XYPlot plot = new XYPlot((XYDataset)this.internalSeriesCollection, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)new XYLineAndShapeRenderer(true, true));
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setDataset((XYDataset)this.internalSeriesCollection);
        this.jchart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        this.chartPanel = new ChartPanel(this.jchart);
        this.chartPanel.setPreferredSize(new Dimension(200, 100));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.chartPanel, new GBC(0, 0).both().weightx(7.0));
        this.add((Component)this.buildTextPanel(), new GBC(1, 0).vertical().weightx(1.0));
        BorderUtil.setTitledBorder((JComponent)this, (String)this.getString("DetailPanel.frame"));
    }
}

