/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph;

import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.exception.BugException;
import csbase.exception.algorithms.ParameterNotFoundException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ParametersTransferable
implements Transferable {
    public static final DataFlavor DATA_FLAVOR;
    private static final String PARAMETER_LABEL = "LABEL";
    private static final String PARAMETER_TYPE = "TYPE";
    private static final String PARAMETER_VALUE = "VALUE";
    private final Map<String, Map<String, String>> parameterMapsByName;

    static {
        try {
            DATA_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref;class=" + ParametersTransferable.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new BugException((Throwable)e);
        }
    }

    public ParametersTransferable(GraphNode node) {
        if (node == null) {
            throw new IllegalArgumentException("O par\u00e2metro node est\u00e1 nulo.");
        }
        this.parameterMapsByName = new HashMap<String, Map<String, String>>();
        Set<String> parameterNames = node.getParameterNames();
        for (String parameterName : parameterNames) {
            String parameterType;
            String parameterValue;
            String parameterLabel;
            try {
                parameterLabel = node.getParameterLabel(parameterName);
                parameterValue = node.getParameterValue(parameterName);
                parameterType = node.getParameterType(parameterName);
            }
            catch (ParameterNotFoundException e) {
                IllegalStateException illegalStateException = new IllegalStateException();
                illegalStateException.initCause(e);
                throw illegalStateException;
            }
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put(PARAMETER_LABEL, parameterLabel);
            parameterMap.put(PARAMETER_VALUE, parameterValue);
            parameterMap.put(PARAMETER_TYPE, parameterType);
            this.parameterMapsByName.put(parameterName, parameterMap);
        }
    }

    public String getParameterLabel(String parameterName) {
        Map<String, String> parameterMap = this.parameterMapsByName.get(parameterName);
        if (parameterMap == null) {
            return null;
        }
        return parameterMap.get(PARAMETER_LABEL);
    }

    public Set<String> getParameterNames() {
        return Collections.unmodifiableSet(this.parameterMapsByName.keySet());
    }

    public String getParameterType(String parameterName) {
        Map<String, String> parameterMap = this.parameterMapsByName.get(parameterName);
        if (parameterMap == null) {
            return null;
        }
        return parameterMap.get(PARAMETER_TYPE);
    }

    public String getParameterValue(String parameterName) {
        Map<String, String> parameterMap = this.parameterMapsByName.get(parameterName);
        if (parameterMap == null) {
            return null;
        }
        return parameterMap.get(PARAMETER_VALUE);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return Collections.unmodifiableMap(this.parameterMapsByName);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DATA_FLAVOR};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return DATA_FLAVOR.equals(flavor);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "\n" + this.parameterMapsByName;
    }
}

