/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.jobmonitor.columns;

import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.jobmonitor.JobMonitorSystemInfo;
import csbase.client.applications.jobmonitor.rowmodel.JobInfoRow;
import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class SystemColumn
extends AbstractConfigurableColumn<JobInfoRow> {
    private JobMonitorSystemInfo systemInfo;
    private String propertyId;

    public SystemColumn(JobMonitorSystemInfo systemInfo, IStringProvider provider, String propertyId) {
        super(systemInfo.getSystemName(), true, provider, null);
        this.systemInfo = systemInfo;
        this.propertyId = propertyId;
    }

    public Class<?> getColumnClass() {
        return Boolean.class;
    }

    public String getColumnName() {
        return this.systemInfo.getSystemName();
    }

    public Boolean getValue(JobInfoRow obj) {
        try {
            return CommandsCache.getInstance().hasCommand(obj.get(this.propertyId));
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public TableCellRenderer createTableCellRenderer() {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                ImageIcon icon = ApplicationImages.TRANSPARENT_BALL_16;
                String toolTip = SystemColumn.this.getString("tool.tip.other");
                Boolean fromSystem = (Boolean)value;
                this.setText(null);
                if (fromSystem.booleanValue()) {
                    icon = SystemColumn.this.systemInfo.getSystemIcon() != null ? SystemColumn.this.systemInfo.getSystemIcon() : ApplicationImages.GRAY_BALL_16;
                    toolTip = String.valueOf(SystemColumn.this.getString("tool.tip.by")) + " " + SystemColumn.this.systemInfo.getSystemName();
                }
                this.setIcon(icon);
                this.setToolTipText(toolTip);
                return this;
            }
        };
    }
}

