/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.jobmonitor.drivers;

import csbase.client.applications.Application;
import csbase.client.applications.jobmonitor.JobMonitor;
import csbase.client.applications.jobmonitor.JobMonitorSystemInfo;
import csbase.client.applications.jobmonitor.columns.DoubleJobInfoColumn;
import csbase.client.applications.jobmonitor.columns.DoubleWithMagnitudeJobInfoColumn;
import csbase.client.applications.jobmonitor.columns.StringJobInfoColumn;
import csbase.client.applications.jobmonitor.columns.SystemColumn;
import csbase.client.applications.jobmonitor.drivers.JobInfoDriver;
import csbase.client.applications.jobmonitor.rowmodel.JobInfoRow;
import csbase.client.facilities.configurabletable.column.IConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.ApplicationStringProvider;
import csbase.client.facilities.configurabletable.table.ConfigurableTable;
import csbase.logic.SGASet;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PBSDriver
extends JobInfoDriver {
    public static final String PBS_DRIVER_TABLE = "PBS_DRIVER_TABLE";
    public static final String ROOT_ELEMENT = "Data";
    public static final String JOB_ELEMENT = "Job";
    public static final String CLUSTER_PROPERTY = "Cluster";
    public static final String JOB_NAME_PROPERTY = "Job_Name";
    private List<String> magnitudes = new ArrayList<String>();

    public PBSDriver(Application application) {
        super(application);
        this.magnitudes.add("kb");
    }

    @Override
    public List<JobInfoRow> getRows(List<SGASet> sgas) {
        LinkedList<JobInfoRow> rows = new LinkedList<JobInfoRow>();
        for (SGASet sgaSet : sgas) {
            String jobsInfo = sgaSet.getJobsInfo();
            Node root = this.parseXML(jobsInfo);
            if (root == null) continue;
            NodeList jobList = root.getChildNodes();
            int i = 0;
            while (i < jobList.getLength()) {
                Node job = jobList.item(i);
                JobInfoRow newLine = new JobInfoRow();
                newLine.add(CLUSTER_PROPERTY, sgaSet.getName());
                NodeList jobInfo = job.getChildNodes();
                int j = 0;
                while (j < jobInfo.getLength()) {
                    Node jobChild = jobInfo.item(j);
                    if (jobChild.getNodeType() == 3) {
                        newLine.add("Job_Id", jobChild.getNodeValue());
                    } else {
                        this.addToNewLine("", jobChild, newLine);
                    }
                    ++j;
                }
                rows.add(newLine);
                ++i;
            }
        }
        return rows;
    }

    @Override
    public ConfigurableTable<JobInfoRow> getTable(List<SGASet> sgas) {
        List<JobInfoRow> rows = this.getRows(sgas);
        List columns = this.getColumns(rows);
        int i = 0;
        while (i < columns.size()) {
            columns.get(i).setVisible(i < 10);
            ++i;
        }
        ConfigurableTable<JobInfoRow> table = null;
        if (columns.size() > 0) {
            this.addExtraColumns(columns);
            table = new ConfigurableTable<JobInfoRow>(PBS_DRIVER_TABLE, columns, null);
            table.updateRows(rows);
        }
        return table;
    }

    private void addExtraColumns(List<IConfigurableColumn<JobInfoRow>> columns) {
        ApplicationStringProvider provider = new ApplicationStringProvider(this.getApplication());
        JobMonitorSystemInfo systemInfo = ((JobMonitor)this.getApplication()).getSystemInfo();
        columns.add(0, new SystemColumn(systemInfo, provider, JOB_NAME_PROPERTY));
    }

    private void addToNewLine(String prefix, Node elem, JobInfoRow line) {
        NodeList children = elem.getChildNodes();
        if (children.getLength() == 0) {
            line.add(String.valueOf(prefix) + elem.getNodeName(), null);
        } else if (children.getLength() == 1 && children.item(0).getNodeType() == 3) {
            String value = children.item(0).getNodeValue();
            line.add(String.valueOf(prefix) + elem.getNodeName(), value);
        } else {
            int i = 0;
            while (i < children.getLength()) {
                this.addToNewLine(String.valueOf(prefix) + elem.getNodeName() + ".", children.item(i), line);
                ++i;
            }
        }
    }

    private List<IConfigurableColumn<JobInfoRow>> getColumns(List<JobInfoRow> rows) {
        Map<String, Set<ColumnType>> columnsTypes = this.inferColumnsType(rows);
        ArrayList<IConfigurableColumn<JobInfoRow>> columns = new ArrayList<IConfigurableColumn<JobInfoRow>>();
        for (Map.Entry<String, Set<ColumnType>> entry : columnsTypes.entrySet()) {
            String columnName = entry.getKey();
            Set<ColumnType> types = entry.getValue();
            if (types.size() == 1) {
                ColumnType type = types.iterator().next();
                switch (type) {
                    case DOUBLE: {
                        columns.add(new DoubleJobInfoColumn(columnName));
                        break;
                    }
                    case DOUBLE_WITH_MAGNITUDE: {
                        columns.add(new DoubleWithMagnitudeJobInfoColumn(columnName, type.getMagnitude()));
                        break;
                    }
                    case STRING: {
                        columns.add(new StringJobInfoColumn(columnName));
                    }
                }
                continue;
            }
            columns.add(new StringJobInfoColumn(columnName));
        }
        return columns;
    }

    private Map<String, Set<ColumnType>> inferColumnsType(List<JobInfoRow> rows) {
        LinkedHashMap<String, Set<ColumnType>> columnsTypes = new LinkedHashMap<String, Set<ColumnType>>();
        for (JobInfoRow row : rows) {
            for (Map.Entry<String, String> entry : row.entrySet()) {
                String columnName = entry.getKey();
                String columnValue = entry.getValue();
                ColumnType type = this.getColumnType(columnValue);
                if (columnsTypes.get(columnName) == null) {
                    columnsTypes.put(columnName, new HashSet());
                }
                ((Set)columnsTypes.get(columnName)).add(type);
            }
        }
        return columnsTypes;
    }

    private ColumnType getColumnType(String columnValue) {
        ColumnType result = ColumnType.STRING;
        if (this.isDouble(columnValue)) {
            result = ColumnType.DOUBLE;
        } else if (this.isDoubleWithMagnitude(columnValue)) {
            result = ColumnType.DOUBLE_WITH_MAGNITUDE;
            result.setMagnitude(this.getMagnitude(columnValue));
        }
        return result;
    }

    private boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isDoubleWithMagnitude(String columnValue) {
        String magnitude = this.getMagnitude(columnValue);
        return magnitude != null;
    }

    private String getMagnitude(String columnValue) {
        for (String m : this.magnitudes) {
            String value;
            if (!columnValue.endsWith(m) || !this.isDouble(value = columnValue.substring(0, columnValue.lastIndexOf(m)))) continue;
            return m;
        }
        return null;
    }

    private Node parseXML(String xml) {
        if (xml == null || xml.isEmpty()) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Element elem = null;
        InputSource input = new InputSource();
        input.setCharacterStream(new StringReader(xml));
        try {
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.parse(input);
            elem = doc.getDocumentElement();
        }
        catch (Exception e) {
            throw new RuntimeException("XML com erro de sintaxe:" + xml, e);
        }
        this.validate(elem, xml);
        return elem;
    }

    private void validate(Node root, String xml) {
        if (!ROOT_ELEMENT.equals(root.getNodeName())) {
            throw new RuntimeException("O elemento root deveria ser 'Data'; XML original:" + xml);
        }
        NodeList jobList = root.getChildNodes();
        if (jobList == null) {
            throw new RuntimeException("Lista de jobs n\u00e3o pode ser nula; XML original:" + xml);
        }
        if (jobList.getLength() == 0) {
            throw new RuntimeException("Lista de jobs deve ter ao menos um job; XML original:" + xml);
        }
        int i = 0;
        while (i < jobList.getLength()) {
            Node job = jobList.item(i);
            if (!JOB_ELEMENT.equals(job.getNodeName())) {
                throw new RuntimeException("Elemento root 'Data' s\u00f3 pode ser composto por elementos 'Job'; XML original:" + xml);
            }
            ++i;
        }
    }

    private static enum ColumnType {
        DOUBLE,
        DOUBLE_WITH_MAGNITUDE,
        STRING;

        private String magnitude = "";

        public void setMagnitude(String magnitude) {
            this.magnitude = magnitude;
        }

        public String getMagnitude() {
            return this.magnitude;
        }
    }
}

