/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.notepad;

import csbase.client.applications.notepad.Notepad;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import tecgraf.javautils.gui.GBC;

final class SearchPanel
extends JPanel {
    private final Notepad application;
    private final JTextComponent component;
    private final JTextField searchTextField;
    private final JCheckBox caseSensitiveCheck;
    private final JButton next;
    private final JButton prev;
    private boolean lastDirectionIsForward = true;
    private final Highlighter.HighlightPainter highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(UIManager.getColor("TextArea.selectionBackground"));
    private Highlighter.Highlight highlight;

    private static void setPreferredHeight(Component component, int height) {
        Dimension prefSize = component.getPreferredSize();
        prefSize.height = height;
        component.setPreferredSize(prefSize);
    }

    private void checkSelection() {
        int mark;
        Caret caret = this.component.getCaret();
        int dot = caret.getDot();
        if (dot > (mark = caret.getMark())) {
            this.select(mark, dot);
        }
    }

    void editSearchString() {
        this.searchTextField.requestFocusInWindow();
        this.searchTextField.selectAll();
    }

    private int find(String contentToSearch, String pattern, int startIndex, boolean backwards, boolean caseSensitive) {
        if (caseSensitive) {
            if (backwards) {
                return contentToSearch.lastIndexOf(pattern, startIndex);
            }
            return contentToSearch.indexOf(pattern, startIndex);
        }
        if (backwards) {
            return this.findBackwardsIgnoreCase(contentToSearch, pattern, startIndex);
        }
        return this.findForwardIgnoreCase(contentToSearch, pattern, startIndex);
    }

    private void findAndSelect(String contentToSearch, String pattern, int startIndex, boolean backwards, boolean caseSensitive) {
        if (pattern == null || pattern.length() == 0) {
            this.application.getApplicationFrame().getStatusBar().clearStatus();
            return;
        }
        if (contentToSearch.length() < pattern.length()) {
            this.application.getApplicationFrame().getStatusBar().clearStatus();
            return;
        }
        int index = this.find(contentToSearch, pattern, startIndex, backwards, caseSensitive);
        if (index >= 0) {
            this.select(index, index + pattern.length());
            String info = "\"" + pattern + "\" " + this.application.getString("SearchPanel.msg.found");
            this.application.getApplicationFrame().getStatusBar().setText(info);
            return;
        }
        if (!backwards && startIndex == 0 || backwards && startIndex == contentToSearch.length() - 1) {
            String info = this.application.getString("SearchPanel.msg.notFound");
            this.application.getApplicationFrame().getStatusBar().setText(info);
            return;
        }
        int initIdx = !backwards ? 0 : contentToSearch.length() - 1;
        index = this.find(contentToSearch, pattern, initIdx, backwards, caseSensitive);
        if (index >= 0) {
            this.select(index, index + pattern.length());
            String info = String.format("\"%s\" %s - %s", pattern, this.application.getString("SearchPanel.msg.found"), this.application.getString("SearchPanel.msg.wrapped" + (backwards ? ".backwards" : "")));
            this.application.getApplicationFrame().getStatusBar().setText(info);
        } else {
            String info = String.format("%s - %s", this.application.getString("SearchPanel.msg.notFound"), this.application.getString("SearchPanel.msg.wrapped" + (backwards ? ".backwards" : "")));
            this.application.getApplicationFrame().getStatusBar().setText(info);
        }
    }

    private int findBackwardsIgnoreCase(String contentToSearch, String pattern, int startIndex) {
        char lower = Character.toLowerCase(pattern.charAt(0));
        char upper = Character.toUpperCase(pattern.charAt(0));
        int pattLen = pattern.length();
        int i = startIndex;
        while (i >= 0) {
            char charAt = contentToSearch.charAt(i);
            if ((charAt == lower || charAt == upper) && contentToSearch.regionMatches(true, i, pattern, 0, pattLen)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private int findForwardIgnoreCase(String contentToSearch, String pattern, int startIndex) {
        Pattern patt = Pattern.compile(pattern, 18);
        Matcher matcher = patt.matcher(contentToSearch);
        return matcher.find(startIndex) ? matcher.start() : -1;
    }

    void findNext() {
        this.lastDirectionIsForward = true;
        this.checkSelection();
        int caretPosition = this.component.getCaretPosition();
        String text = this.component.getText();
        if (caretPosition > text.length() - 1) {
            caretPosition = text.length() - 1;
        }
        this.findAndSelect(text, this.searchTextField.getText(), caretPosition + 1, false, this.caseSensitiveCheck.isSelected());
    }

    void findPrevious() {
        this.lastDirectionIsForward = false;
        this.checkSelection();
        int caretPosition = this.component.getCaretPosition();
        this.findAndSelect(this.component.getText(), this.searchTextField.getText(), caretPosition - 1, true, this.caseSensitiveCheck.isSelected());
    }

    private void highlight(int start, int end) {
        this.removeHighlight();
        try {
            this.highlight = (Highlighter.Highlight)this.component.getHighlighter().addHighlight(start, end, this.highlightPainter);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void removeHighlight() {
        if (this.highlight != null) {
            this.component.getHighlighter().removeHighlight(this.highlight);
            this.highlight = null;
        }
    }

    void searchAgain() {
        if (this.lastDirectionIsForward) {
            this.findNext();
        } else {
            this.findPrevious();
        }
    }

    private void select(int startIndex, int endIndex) {
        this.component.setCaretPosition(endIndex);
        this.component.moveCaretPosition(startIndex);
        this.highlight(startIndex, endIndex);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            String selectedText = this.component.getSelectedText();
            if (selectedText != null) {
                if (selectedText.indexOf(10) < 0) {
                    this.searchTextField.setText(selectedText);
                } else {
                    this.component.select(0, 0);
                }
            }
            this.searchTextField.selectAll();
            this.searchTextField.requestFocusInWindow();
        } else {
            this.removeHighlight();
        }
    }

    SearchPanel(Notepad app, JTextComponent comp) {
        super(new GridBagLayout());
        this.component = comp;
        this.application = app;
        comp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SearchPanel.this.removeHighlight();
            }
        });
        JLabel findLabel = new JLabel(this.application.getString("SearchPanel.find"));
        this.searchTextField = new JTextField(3);
        this.caseSensitiveCheck = new JCheckBox(this.application.getString("SearchPanel.caseSensitive"));
        this.next = new JButton(this.application.getString("SearchPanel.next"));
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.findNext();
            }
        });
        this.prev = new JButton(this.application.getString("SearchPanel.previous"));
        this.prev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.findPrevious();
            }
        });
        Dimension prefSize = this.searchTextField.getPreferredSize();
        int prefHeight = prefSize.height;
        SearchPanel.setPreferredHeight(this.next, prefHeight);
        SearchPanel.setPreferredHeight(this.prev, prefHeight);
        SearchPanel.setPreferredHeight(findLabel, prefHeight);
        SearchPanel.setPreferredHeight(this.caseSensitiveCheck, prefHeight);
        int top = 5;
        int bottom = 5;
        int left = 5;
        Insets insets = new Insets(5, 5, 5, 0);
        this.add((Component)new CloseButton(), new GBC().insets(5, 5, 5, 5));
        this.add((Component)findLabel, new GBC(1, 0).insets(insets));
        this.add((Component)this.searchTextField, new GBC(2, 0).insets(insets).horizontal());
        this.add((Component)this.next, new GBC(3, 0).insets(insets));
        this.add((Component)this.prev, new GBC(4, 0).insets(insets));
        this.add((Component)this.caseSensitiveCheck, new GBC(5, 0).insets(5, 10, 5, 5));
        InputMap inputMap = this.getInputMap(1);
        ActionMap aMap = this.getActionMap();
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
        AbstractAction enterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.searchAgain();
            }
        };
        inputMap.put(enterKey, enterKey.toString());
        aMap.put(enterKey.toString(), enterAction);
        KeyStroke escKey = KeyStroke.getKeyStroke(27, 0);
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.setVisible(false);
            }
        };
        inputMap.put(escKey, escKey.toString());
        aMap.put(escKey.toString(), escAction);
    }

    private class CloseButton
    extends JButton
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            SearchPanel.this.setVisible(false);
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        CloseButton() {
            super(UIManager.getIcon("InternalFrame.closeIcon"));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusPainted(false);
            this.addActionListener(this);
        }
    }
}

