/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.preferenceviewer.tree;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applications.preferenceviewer.PreferencePanel;
import csbase.client.applications.preferenceviewer.PreferenceViewer;
import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.PreferenceManager;
import csbase.client.preferences.util.PreferencesUtil;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import tecgraf.javautils.core.io.FileUtils;

class PreferenceTreeCellRenderer
extends DefaultTreeCellRenderer {
    private PreferencePanel preferencePanel;
    private PreferenceViewer app;
    private Map<String, String> appMemoization;
    private Map<PreferenceCategory, Icon> iconMemoization;

    public PreferenceTreeCellRenderer(PreferencePanel preferencePanel, PreferenceViewer app) {
        this.preferencePanel = preferencePanel;
        this.app = app;
        this.appMemoization = new HashMap<String, String>();
        this.iconMemoization = new HashMap<PreferenceCategory, Icon>();
        ApplicationManager am = ApplicationManager.getInstance();
        for (ApplicationRegistry registry : am.getAllApplicationRegistries()) {
            String enumName = PreferencesUtil.getAppEnumName(registry);
            this.appMemoization.put(enumName, registry.getId());
        }
        this.createAllIcons();
    }

    private void createAllIcons() {
        PreferenceManager pm = PreferenceManager.getInstance();
        PreferenceCategory root = pm.loadPreferences();
        this.defineIcons(root);
    }

    private void defineIcons(PreferenceCategory pc) {
        this.iconMemoization.put(pc, this.createPreferenceNodeIcon(pc));
        for (PreferenceCategory child : pc.getCategories()) {
            this.defineIcons(child);
        }
    }

    private Icon createPreferenceNodeIcon(PreferenceCategory pc) {
        ImageIcon icon = null;
        if (this.appMemoization.containsKey(pc.getId())) {
            ApplicationManager am = ApplicationManager.getInstance();
            String appId = this.appMemoization.get(pc.getId());
            icon = am.getApplicationIcon(appId);
        } else {
            int begin = pc.getId().lastIndexOf(".") + 1;
            int end = pc.getId().length();
            if (begin != -1) {
                String iconName = String.valueOf(pc.getId().substring(begin, end)) + ".gif";
                InputStream input = this.app.getResource(new String[]{iconName});
                if (input != null) {
                    try {
                        try {
                            BufferedImage image = ImageIO.read(input);
                            icon = new ImageIcon(image);
                        }
                        catch (IOException iOException) {
                            FileUtils.close((Closeable)input);
                        }
                    }
                    finally {
                        FileUtils.close((Closeable)input);
                    }
                }
            }
        }
        return icon;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel cell = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        PreferenceCategory pc = (PreferenceCategory)value;
        if (this.preferencePanel.getModifiedCategories() != null && this.preferencePanel.getModifiedCategories().contains(pc)) {
            cell.setText(String.valueOf(pc.getLabel()) + "*");
        } else {
            cell.setText(String.valueOf(pc.getLabel()) + " ");
        }
        cell.setIcon(this.iconMemoization.get(pc));
        return cell;
    }
}

