/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.preferenceviewer.tree;

import csbase.client.preferences.PreferenceCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class PreferenceTreeModel
implements TreeModel {
    private PreferenceCategory root;
    private List<String> order;
    private List<TreeModelListener> listeners;

    public PreferenceTreeModel(PreferenceCategory root) {
        this.root = root;
        this.listeners = new ArrayList<TreeModelListener>();
    }

    public void setOrder(List<String> order) {
        this.order = order;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        PreferenceCategory pc = (PreferenceCategory)parent;
        return this.getChildren(pc).get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        PreferenceCategory pc = (PreferenceCategory)parent;
        return pc.getCategories().size();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        PreferenceCategory parentPc = (PreferenceCategory)parent;
        PreferenceCategory childPc = (PreferenceCategory)child;
        List<PreferenceCategory> children = this.getChildren(parentPc);
        return children.indexOf(childPc);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        PreferenceCategory pc = (PreferenceCategory)node;
        return pc.getCategories().isEmpty();
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    private List<PreferenceCategory> getChildren(PreferenceCategory pc) {
        List<PreferenceCategory> children = pc.getCategories();
        Collections.sort(children, new Comparator<PreferenceCategory>(){

            @Override
            public int compare(PreferenceCategory c1, PreferenceCategory c2) {
                return c1.getLabel().compareTo(c2.getLabel());
            }
        });
        if (this.order != null) {
            int i = 0;
            while (i < this.order.size()) {
                String elem = this.order.get(i);
                int j = 0;
                while (j < children.size()) {
                    if (children.get(j).getId().endsWith(elem)) {
                        PreferenceCategory child = children.remove(j);
                        children.add(i, child);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return children;
    }
}

