/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.StatusDialog;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.RemoveProjectTask;
import csbase.logic.User;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import tecgraf.javautils.gui.StandardDialogs;

public class RemoveProjectAction
extends ProjectsManagerAction {
    public RemoveProjectAction(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    public void actionDone() throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        List<ProjectsManagerData> projectList = projectsManager.getSelectedProjects();
        if (projectList == null || projectList.size() <= 0) {
            return;
        }
        ApplicationFrame frame = projectsManager.getApplicationFrame();
        List<ProjectsManagerData> projects = this.validateProjects(projectList);
        if (projects == null) {
            return;
        }
        boolean ret = this.runTask(projects);
        if (ret) {
            projectsManager.removeProjects(projects);
        } else {
            StandardDialogs.showInfoDialog((Component)frame, (String)this.getString("RemoveProjectAction.project.removal.error.title"), (Object)this.getString("RemoveProjectAction.project.removal.error.message"));
        }
    }

    private boolean runTask(List<ProjectsManagerData> projects) throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        ApplicationFrame frame = projectsManager.getApplicationFrame();
        RemoveProjectTask prt = new RemoveProjectTask(projectsManager, projects);
        prt.execute(frame, this.getString("RemoveProjectAction.title"), this.getString("RemoveProjectAction.message"));
        if (prt.wasCancelled()) {
            String err = this.getString("RemoveProjectAction.cancelled.message");
            prt.showError(err);
            return false;
        }
        if (!prt.getStatus()) {
            Exception exception = prt.getError();
            throw exception;
        }
        return (Boolean)prt.getResult();
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return ApplicationImages.ICON_DELETE_16;
    }

    @Override
    protected List<ProjectsManagerData> validateProjects(List<ProjectsManagerData> projectList) {
        int res;
        String someDeniedMessage;
        int res2;
        ArrayList<ProjectsManagerData> prjList = new ArrayList<ProjectsManagerData>();
        prjList.addAll(projectList);
        ArrayList<ProjectsManagerData> failedProjects = new ArrayList<ProjectsManagerData>();
        int i = 0;
        while (i < prjList.size()) {
            ProjectsManagerData pmd = (ProjectsManagerData)prjList.get(i);
            ProjectSpaceAllocation spaceAllocation = pmd.getProjectSpaceAllocation();
            if (spaceAllocation == ProjectSpaceAllocation.WAITING_ALLOCATION || spaceAllocation == ProjectSpaceAllocation.WAITING_DEALLOCATION) {
                failedProjects.add(pmd);
                prjList.remove(i);
                continue;
            }
            User loggedUser = User.getLoggedUser();
            String loggedUserId = loggedUser.getLogin();
            if (!loggedUser.isAdmin() && !pmd.getOwnerId().equals(loggedUserId)) {
                failedProjects.add(pmd);
                prjList.remove(i);
                continue;
            }
            ++i;
        }
        ProjectsManager projectsManager = this.getProjectsManager();
        if (prjList.size() == 0) {
            String deniedMessage = String.valueOf(this.getString("RemoveProjectAction.project.selection.denied.message")) + this.getString("RemoveProjectAction.project.requirements.message");
            StatusDialog.showNoneOkDialog(projectsManager, deniedMessage, failedProjects, this.getString("RemoveProjectAction.project.selection.failure.message"));
            return null;
        }
        if (failedProjects.size() > 0 ? (res2 = StatusDialog.showSomeOkDialog(projectsManager, someDeniedMessage = String.valueOf(this.getString("RemoveProjectAction.project.selection.some.denied.message")) + this.getString("RemoveProjectAction.project.requirements.message"), prjList, this.getString("RemoveProjectAction.project.selection.some.failure.message"))) == 0 : (res = StatusDialog.showAllOkDialog(projectsManager, this.getString("RemoveProjectAction.confirm.removal.dialog"))) == 0) {
            return null;
        }
        return prjList;
    }
}

