/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions.core;

import csbase.client.applications.ApplicationAction;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.ImageIcon;

public abstract class ProjectsManagerAction
extends ApplicationAction<ProjectsManager> {
    protected static final String TAG_NAME = "name";
    protected static final String TAG_MNEMONIC = "mnemonic";
    protected static final String TAG_TOOLTIP = "tooltip";

    public final ProjectsManager getProjectsManager() {
        return (ProjectsManager)this.getApplication();
    }

    public ImageIcon getStandardImageIcon() {
        return null;
    }

    private void loadDefaultValues() {
        String tooltip;
        ImageIcon icon;
        Integer mnemonic;
        String name = this.getName();
        if (name != null) {
            this.putValue("Name", name);
        }
        if ((mnemonic = this.getMnemonic()) != null) {
            this.putValue("MnemonicKey", mnemonic);
        }
        if ((icon = this.getImageIcon()) != null) {
            this.putValue("SmallIcon", icon);
        }
        if ((tooltip = this.getToolTipText()) != null) {
            this.putValue("ShortDescription", tooltip);
        }
    }

    public String getClassString(String tag) {
        return ProjectsManagerUI.getClassString(this.getClass(), tag);
    }

    public String getString(String tag) {
        return ProjectsManagerUI.getString(tag);
    }

    public final boolean hasString(String tag) {
        return ProjectsManagerUI.hasClassString(this.getClass(), tag);
    }

    public final String getName() {
        if (!this.hasString(TAG_NAME)) {
            return null;
        }
        String name = this.getClassString(TAG_NAME);
        if (ProjectsManagerUI.isEmptyString(name)) {
            return null;
        }
        return name;
    }

    public final String getToolTipText() {
        if (!this.hasString(TAG_TOOLTIP)) {
            return null;
        }
        String tp = this.getClassString(TAG_TOOLTIP);
        if (ProjectsManagerUI.isEmptyString(tp)) {
            return null;
        }
        return tp;
    }

    public final Integer getMnemonic() {
        if (!this.hasString(TAG_MNEMONIC)) {
            return null;
        }
        String mn = this.getClassString(TAG_MNEMONIC);
        if (ProjectsManagerUI.isEmptyString(mn)) {
            return null;
        }
        return mn.charAt(0);
    }

    private final ImageIcon getImageIcon() {
        String name;
        ImageIcon stdIcon = this.getStandardImageIcon();
        if (stdIcon != null) {
            return stdIcon;
        }
        String prefix = this.getClass().getSimpleName();
        String pth = name = String.valueOf(prefix) + ".16";
        ProjectsManager projectsManager = this.getProjectsManager();
        ImageIcon icon = projectsManager.buildApplicationImage(pth);
        if (icon == ApplicationImages.ICON_NONE) {
            return null;
        }
        return icon;
    }

    @Override
    public final void actionPerformed(ActionEvent ae) {
        try {
            this.actionDone();
        }
        catch (Exception e) {
            ProjectsManager projectsManager = this.getProjectsManager();
            ProjectsManagerUI.handleException(projectsManager, e);
        }
    }

    public ProjectsManagerAction(ProjectsManager projectsManager) {
        super(projectsManager);
        this.loadDefaultValues();
    }

    protected List<ProjectsManagerData> validateProjects(List<ProjectsManagerData> projectList) {
        return null;
    }

    public abstract void actionDone() throws Exception;
}

