/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.dialogs;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.applications.projectsmanager.dialogs.core.ProjectsManagerDialog;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.ChangeServerOwnerProjectTask;
import csbase.client.applications.projectsmanager.proxy.ReloadSelectedProjectsTask;
import csbase.client.desktop.RemoteTask;
import csbase.remote.ClientRemoteLocator;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.table.SortableTable;

public class ChangeServerOwnerProjectDialog
extends ProjectsManagerDialog {
    private JTextField newOwnerServerNameText;
    private List<ProjectsManagerData> projectsManagerData;

    public ChangeServerOwnerProjectDialog(ProjectsManager projectsManager, List<ProjectsManagerData> projectsManagerData) {
        super(projectsManager);
        this.projectsManagerData = projectsManagerData;
        this.buildPanel();
    }

    private JPanel buildButtonsPanel() {
        JButton changeButton = new JButton();
        JButton cancelButton = new JButton();
        final ChangeServerOwnerProjectDialog phd = this;
        changeButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List ret;
                ProjectsManager projectsManager = ChangeServerOwnerProjectDialog.this.getProjectsManager();
                ChangeServerOwnerProjectTask task = new ChangeServerOwnerProjectTask(projectsManager, ChangeServerOwnerProjectDialog.this.projectsManagerData, ChangeServerOwnerProjectDialog.this.newOwnerServerNameText.getText());
                ApplicationFrame appFrame = projectsManager.getApplicationFrame();
                String taskTitle = ChangeServerOwnerProjectDialog.this.getString("ChangeServerOwnerProjectDialog.running.title");
                String taskMsg = ChangeServerOwnerProjectDialog.this.getString("ChangeServerOwnerProjectDialog.running.message");
                task.execute(appFrame, taskTitle, taskMsg);
                if (task.wasCancelled()) {
                    String err = ChangeServerOwnerProjectDialog.this.getString("ChangeServerOwnerProjectDialog.cancelled.message");
                    task.showError(err);
                    return;
                }
                if (!task.getStatus()) {
                    Exception exception = task.getError();
                    String err = ChangeServerOwnerProjectDialog.this.getString("ChangeServerOwnerProjectDialog.change.server.name.error.message");
                    String msg = String.valueOf(err) + "\n" + exception.getMessage();
                    StandardDialogs.showErrorDialog((Component)appFrame, (String)"", (String)msg);
                }
                if ((ret = (List)task.getResult()) != null && ret.size() > 0) {
                    StringBuilder text = new StringBuilder();
                    for (ProjectsManagerData prj : ret) {
                        text.append(" - " + prj.getProjectName() + "\n");
                    }
                    String err = ChangeServerOwnerProjectDialog.this.getString("ChangeServerOwnerProjectDialog.failure.change.some.server.name.message");
                    String msg = String.valueOf(err) + "\n" + text.toString();
                    StandardDialogs.showErrorDialog((Component)((ProjectsManager)ChangeServerOwnerProjectDialog.this.getApplication()).getApplicationFrame(), (String)"", (String)msg);
                }
                ChangeServerOwnerProjectDialog.this.projectsManagerData = ChangeServerOwnerProjectDialog.this.runUpdateProjectDataTask();
                projectsManager.refreshProjectsTable();
                phd.dispose();
            }
        });
        changeButton.setText(this.getString("ChangeServerOwnerProjectDialog.change.button"));
        cancelButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                phd.dispose();
            }
        });
        cancelButton.setText(this.getString("ChangeServerOwnerProjectDialog.cancel.button"));
        JComponent[] buttons = new JComponent[]{changeButton, cancelButton};
        GUIUtils.matchPreferredSizes((JComponent[])buttons);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(changeButton);
        buttonsPanel.add(cancelButton);
        this.getRootPane().setDefaultButton(changeButton);
        return buttonsPanel;
    }

    private JPanel buildTextPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GBC gbc = new GBC(0, 0).west().insets(10, 15, 10, 0);
        JLabel newServerNameLabel = new JLabel(this.getString("ChangeServerOwnerProjectDialog.new.owner.label"));
        panel.add((Component)newServerNameLabel, gbc);
        this.newOwnerServerNameText = new JTextField(15);
        this.newOwnerServerNameText.setText(this.getRemoteSystemName());
        gbc = new GBC(1, 0).insets(10).horizontal();
        panel.add((Component)this.newOwnerServerNameText, gbc);
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                ChangeServerOwnerProjectDialog.this.newOwnerServerNameText.requestFocusInWindow();
            }
        });
        return panel;
    }

    private String getRemoteSystemName() {
        String serverName = null;
        RemoteTask<String> task = new RemoteTask<String>(){

            public void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.server.getSystemName());
            }
        };
        task.setProgressDialogDelay(10);
        task.execute(this.getOwner(), "", "");
        if (!task.getStatus()) {
            serverName = "";
        }
        if ((serverName = (String)task.getResult()) == null) {
            serverName = "";
        }
        return serverName;
    }

    private void buildPanel() {
        JPanel buttonsPanel = this.buildButtonsPanel();
        JPanel textPanel = this.buildTextPanel();
        this.setLayout(new GridBagLayout());
        SortableTable table = new SortableTable((TableModel)new ChangeServerModel());
        this.add((Component)new JScrollPane((Component)table), new GBC(0, 0).both().insets(10));
        this.add((Component)textPanel, new GBC(0, 1).both());
        this.add((Component)buttonsPanel, new GBC(0, 2).horizontal());
    }

    private List<ProjectsManagerData> runUpdateProjectDataTask() {
        ProjectsManager projectsManager = this.getProjectsManager();
        ReloadSelectedProjectsTask rspt = new ReloadSelectedProjectsTask(projectsManager, this.projectsManagerData);
        rspt.execute(projectsManager.getApplicationFrame(), this.getString("ChangeServerOwnerProjectDialog.title"), this.getString("ChangeServerOwnerProjectDialog.message"));
        if (rspt.wasCancelled()) {
            String err = this.getString("ChangeServerOwnerProjectDialog.cancelled.message");
            rspt.showError(err);
            return null;
        }
        if (!rspt.getStatus()) {
            Exception exception = rspt.getError();
            ProjectsManagerUI.handleException(this.getProjectsManager(), exception);
            return null;
        }
        List projectList = (List)rspt.getResult();
        if (projectList == null) {
            String errTitle = this.getString("ChangeServerOwnerProjectDialog.modification.date.title");
            String errMsg = this.getString("ChangeServerOwnerProjectDialog.modification.date.message");
            StandardDialogs.showErrorDialog((Component)this.getProjectsManager().getApplicationFrame(), (String)errTitle, (String)errMsg);
            return null;
        }
        return projectList;
    }

    private class ChangeServerModel
    extends DefaultTableModel {
        private ChangeServerModel() {
        }

        @Override
        public String getColumnName(int column) {
            return ChangeServerOwnerProjectDialog.this.getString("ChangeServerOwnerProjectDialog.model.column.name." + column);
        }

        @Override
        public Object getValueAt(int row, int column) {
            ProjectsManagerData elem = (ProjectsManagerData)ChangeServerOwnerProjectDialog.this.projectsManagerData.get(row);
            if (column == 0) {
                return elem.getScope().getIcon();
            }
            if (column == 1) {
                return elem.getProjectName();
            }
            return elem.getServerOwnerName();
        }

        @Override
        public int getRowCount() {
            return ChangeServerOwnerProjectDialog.this.projectsManagerData.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Object v = this.getValueAt(0, columnIndex);
            if (v == null) {
                return null;
            }
            return v.getClass();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

