/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.dialogs;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.dialogs.core.ProjectsManagerDialog;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.panels.ProjectSharingInfoPanel;
import csbase.client.applications.projectsmanager.proxy.AddPersonalCommentTask;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;

public class ProjectCommentsDialog
extends ProjectsManagerDialog {
    private List<ProjectsManagerData> projectsManagerData;
    private final JTextArea commentArea = new JTextArea();

    public ProjectCommentsDialog(ProjectsManager projectsManager, List<ProjectsManagerData> projectsManagerData) {
        super(projectsManager);
        this.projectsManagerData = projectsManagerData;
        this.buildPanel();
    }

    private JPanel buildButtonsPanel() {
        JButton writeButton = new JButton();
        JButton cancelButton = new JButton();
        final ProjectCommentsDialog phd = this;
        writeButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List ret;
                ProjectsManager projectsManager = ProjectCommentsDialog.this.getProjectsManager();
                AddPersonalCommentTask aphbt = new AddPersonalCommentTask(projectsManager, ProjectCommentsDialog.this.projectsManagerData, ProjectCommentsDialog.this.commentArea.getText());
                ApplicationFrame appFrame = projectsManager.getApplicationFrame();
                String taskTitle = ProjectCommentsDialog.this.getString("ProjectCommentsDialog.running.title");
                String taskMsg = ProjectCommentsDialog.this.getString("ProjectCommentsDialog.running.message");
                aphbt.execute(appFrame, taskTitle, taskMsg);
                if (aphbt.wasCancelled()) {
                    String err = ProjectCommentsDialog.this.getString("ProjectCommentsDialog.cancelled.message");
                    aphbt.showError(err);
                    return;
                }
                if (!aphbt.getStatus()) {
                    Exception exception = aphbt.getError();
                    String err = ProjectCommentsDialog.this.getString("ProjectCommentsDialog.comment.inclusion.error.message");
                    String msg = String.valueOf(err) + "\n" + exception.getMessage();
                    StandardDialogs.showErrorDialog((Component)appFrame, (String)"", (String)msg);
                }
                if ((ret = (List)aphbt.getResult()) != null && ret.size() > 0) {
                    StringBuilder text = new StringBuilder();
                    for (ProjectsManagerData prj : ret) {
                        text.append(" - " + prj.getProjectName() + "\n");
                    }
                    String err = ProjectCommentsDialog.this.getString("ProjectCommentsDialog.failure.inserting.some.comment.message");
                    String msg = String.valueOf(err) + "\n" + text.toString();
                    StandardDialogs.showWarningDialog((Component)appFrame, (String)"", (String)msg);
                }
                phd.dispose();
            }
        });
        writeButton.setText(this.getString("ProjectCommentsDialog.insert.text"));
        cancelButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                phd.dispose();
            }
        });
        cancelButton.setText(this.getString("ProjectCommentsDialog.cancel.text"));
        JComponent[] buttons = new JComponent[]{writeButton, cancelButton};
        GUIUtils.matchPreferredSizes((JComponent[])buttons);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(writeButton);
        buttonsPanel.add(cancelButton);
        return buttonsPanel;
    }

    private JScrollPane buildTextPane() {
        this.commentArea.setRows(5);
        this.commentArea.setColumns(40);
        this.commentArea.setLineWrap(true);
        JScrollPane pane = new JScrollPane(this.commentArea);
        BorderUtil.setTitledBorder((JComponent)pane, (String)this.getString("ProjectCommentsDialog.comment.area.title"));
        return pane;
    }

    private ProjectSharingInfoPanel buildProjectPanel() {
        ProjectsManager projectsManager = this.getProjectsManager();
        ProjectSharingInfoPanel projectsPanel = new ProjectSharingInfoPanel(projectsManager, this.projectsManagerData, false);
        BorderUtil.setTitledBorder((JComponent)projectsPanel, (String)this.getString("ProjectCommentsDialog.projects.title"));
        return projectsPanel;
    }

    private void buildPanel() {
        JPanel buttonsPanel = this.buildButtonsPanel();
        JScrollPane pane = this.buildTextPane();
        ProjectSharingInfoPanel projectsPanel = this.buildProjectPanel();
        this.setLayout(new GridBagLayout());
        this.add((Component)projectsPanel, new GBC(0, 0).horizontal());
        this.add((Component)pane, new GBC(0, 1).both());
        this.add((Component)buttonsPanel, new GBC(0, 2).horizontal());
    }
}

