/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.dialogs;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.dialogs.ProjectListTableModel;
import csbase.client.applications.projectsmanager.dialogs.core.ProjectsManagerDialog;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.table.SortableTable;

public class ReplicateSharedDialog
extends ProjectsManagerDialog {
    private final ProjectsManagerData project;
    private SortableTable projectsTable;
    private JButton confirmButton;
    private JButton cancelButton;
    private Set<ProjectsManagerData> selectedProjects;

    public ReplicateSharedDialog(ProjectsManager projectsManager, ProjectsManagerData project) {
        super(projectsManager);
        this.project = project;
        String title = String.valueOf(this.getString("ReplicateSharedDialog.title")) + " " + project.getProjectName();
        this.setTitle(title);
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        JPanel projectListPanel = this.createProjectListPanel();
        JPanel buttonsPanel = this.createButtonsPanel();
        this.add((Component)projectListPanel, new GBC(0, 0).both());
        this.add((Component)buttonsPanel, new GBC(0, 1).horizontal().bottom(10));
    }

    private JPanel createButtonsPanel() {
        JPanel panel = new JPanel();
        this.confirmButton = new JButton(LNG.get((String)"ReplicateSharedDialog.button.confirm"));
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplicateSharedDialog.this.setSelectedProjects();
                ReplicateSharedDialog.this.dispose();
            }
        });
        this.cancelButton = new JButton(LNG.get((String)"ReplicateSharedDialog.button.cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplicateSharedDialog.this.selectedProjects = null;
                ReplicateSharedDialog.this.dispose();
            }
        });
        panel.add(this.confirmButton);
        panel.add(this.cancelButton);
        return panel;
    }

    private JPanel createProjectListPanel() {
        ProjectsManager projectsManager = this.getProjectsManager();
        List<ProjectsManagerData> filteredProjects = projectsManager.getVisibleProjects();
        ArrayList<ProjectsManagerData> projectsRW = new ArrayList<ProjectsManagerData>();
        Object ownerID = ProjectsManager.getUser().getId();
        for (ProjectsManagerData pmd : filteredProjects) {
            ProjectSpaceAllocation spaceAllocation = pmd.getProjectSpaceAllocation();
            if (!pmd.userIsOwner(ownerID) || !spaceAllocation.isOpenable()) continue;
            projectsRW.add(pmd);
        }
        projectsRW.remove(this.project);
        JPanel panel = new JPanel(new GridBagLayout());
        this.projectsTable = new SortableTable((TableModel)new ProjectListTableModel(projectsRW));
        this.projectsTable.setRowSelectionAllowed(true);
        this.projectsTable.setSelectionMode(2);
        this.projectsTable.setFillsViewportHeight(true);
        this.projectsTable.setUseDisabledLook(true);
        this.projectsTable.setEnabled(true);
        GBC gbc = new GBC(0, 0).both().insets(10, 10, 5, 10);
        panel.add((Component)new JScrollPane((Component)this.projectsTable), gbc);
        gbc = new GBC(0, 2).insets(0, 10, 10, 10).west();
        JLabel info = new JLabel(LNG.get((String)"ReplicateSharedDialog.info.applyToOthers"), ApplicationImages.ICON_INFORMATION_16, 2);
        info.setFont(new Font("Sans", 0, 12));
        panel.add((Component)info, gbc);
        return panel;
    }

    private void setSelectedProjects() {
        int[] selectedIdxs;
        this.selectedProjects = new HashSet<ProjectsManagerData>();
        ProjectListTableModel model = (ProjectListTableModel)this.projectsTable.getModel();
        int[] nArray = selectedIdxs = this.projectsTable.getSelectedRows();
        int n = selectedIdxs.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.selectedProjects.add(model.getProject(this.projectsTable.convertRowIndexToModel(i)));
            ++n2;
        }
    }

    public Set<ProjectsManagerData> getSelectedProjects() {
        return this.selectedProjects;
    }
}

