/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.dialogs;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.dialogs.core.ProjectsManagerDialog;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.panels.ProjectSharingInfoPanel;
import csbase.logic.UserProjectInfo;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class StatusDialog
extends ProjectsManagerDialog {
    private final String decisionMessage;
    private String descriptionMessage;
    private List<ProjectsManagerData> projects;
    private int returnValue;
    private final Insets insets = new Insets(7, 11, 7, 12);
    private final Insets topInsets = new Insets(15, 11, 2, 12);

    private StatusDialog(ProjectsManager projectsManager, String descriptionMessage, List<ProjectsManagerData> projects, String decisionMessage) {
        super(projectsManager);
        this.projects = projects;
        this.descriptionMessage = descriptionMessage;
        this.decisionMessage = decisionMessage;
        this.setTitle(this.getString("StatusDialog.invalid.projects.title"));
        this.setLayout(new GridBagLayout());
    }

    private StatusDialog(ProjectsManager projectsManager, String decisionMessage) {
        super(projectsManager);
        this.decisionMessage = decisionMessage;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(this.getString("StatusDialog.projects.status.title"));
        this.setLayout(new GridBagLayout());
    }

    private void buildProjectMessagePanel(boolean error) {
        JPanel descriptionPanel = new JPanel(new GridBagLayout());
        if (this.descriptionMessage.contains("<li>")) {
            int idx = this.descriptionMessage.indexOf("<li>");
            String msg1 = this.descriptionMessage.substring(0, idx);
            String msg2 = this.descriptionMessage.substring(idx);
            msg1 = "<html>" + msg1.replace("\n", "<br>") + "</html>";
            msg2 = "<html>" + msg2.replace("\n", "<br>") + "</html>";
            JLabel label1 = new JLabel(msg1);
            ImageIcon icon = !error ? ApplicationImages.ICON_WARNING_24 : ApplicationImages.ICON_ERROR_24;
            label1.setIcon(icon);
            JLabel label2 = new JLabel(msg2);
            descriptionPanel.add((Component)label1, new GBC(0, 0).west());
            descriptionPanel.add((Component)label2, new GBC(0, 1).west());
        } else {
            JLabel label = new JLabel("<html>" + this.descriptionMessage.replace("\n", "<br>") + "</html>");
            ImageIcon icon = !error ? ApplicationImages.ICON_WARNING_24 : ApplicationImages.ICON_ERROR_24;
            label.setIcon(icon);
            descriptionPanel.add((Component)label, new GBC(0, 0).west());
        }
        this.add((Component)descriptionPanel, new GBC(0, 0).insets(this.topInsets));
    }

    private void buildProjectListPanel(boolean showOwnerId) {
        ProjectSharingInfoPanel infoPanel = new ProjectSharingInfoPanel(this.getProjectsManager(), this.projects, showOwnerId);
        infoPanel.setPreferredSize(new Dimension(330, 70));
        this.add((Component)infoPanel, new GBC(0, 1).center());
    }

    private void buildDecisionPanel() {
        JPanel confirmPanel = new JPanel(new GridBagLayout());
        String labelText = "<html>" + this.decisionMessage.replace("\n", "<br>") + "</html>";
        JLabel label = new JLabel(labelText);
        confirmPanel.add((Component)label, new GBC(0, 0).west());
        this.add((Component)confirmPanel, new GBC(0, 2).center().horizontal().insets(this.insets));
    }

    private void addOkButtons() {
        JButton button = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusDialog.this.dispose();
            }
        });
        button.setText(this.getString("StatusDialog.ok.text"));
        JPanel buttonPanel = GUIUtils.createBasicGridPanel((JComponent[][])new JComponent[][]{{button}});
        this.add((Component)buttonPanel, new GBC(0, 3).center());
    }

    private void addYesNoButtons() {
        JButton yesButton = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusDialog.this.returnValue = 1;
                StatusDialog.this.dispose();
            }
        });
        yesButton.setText(this.getString("StatusDialog.yes.text"));
        JButton noButton = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusDialog.this.returnValue = 0;
                StatusDialog.this.dispose();
            }
        });
        noButton.setText(this.getString("StatusDialog.no.text"));
        JComponent[] buttons = new JComponent[]{yesButton, noButton};
        GUIUtils.matchPreferredSizes((JComponent[])buttons);
        JPanel buttonsPanel = new JPanel(new FlowLayout(1, 11, 11));
        buttonsPanel.add(buttons[0]);
        buttonsPanel.add(buttons[1]);
        this.add((Component)buttonsPanel, new GBC(0, 3).horizontal());
    }

    public static void showNoneOkDialog(ProjectsManager projectsManager, String descriptionMessage, ProjectsManagerData project, String decisionMessage) {
        if (project == null) {
            StatusDialog.showNoneOkDialog(projectsManager, descriptionMessage, null, decisionMessage);
        }
        ArrayList<ProjectsManagerData> projects = new ArrayList<ProjectsManagerData>();
        projects.add(project);
        StatusDialog.showNoneOkDialog(projectsManager, descriptionMessage, projects, decisionMessage);
    }

    public static void showNoneOkDialog(ProjectsManager projectsManager, String descriptionMessage, List<ProjectsManagerData> projects, String decisionMessage) {
        StatusDialog statusDialog = new StatusDialog(projectsManager, descriptionMessage, projects, decisionMessage);
        statusDialog.buildProjectMessagePanel(true);
        statusDialog.buildDecisionPanel();
        statusDialog.addOkButtons();
        statusDialog.pack();
        statusDialog.setVisible(true);
    }

    public static int showSomeOkDialog(ProjectsManager projectsManager, String descriptionMessage, List<ProjectsManagerData> projects, String decisionMessage) {
        StatusDialog statusDialog = new StatusDialog(projectsManager, descriptionMessage, projects, decisionMessage);
        statusDialog.buildProjectMessagePanel(false);
        statusDialog.buildProjectListPanel(true);
        statusDialog.buildDecisionPanel();
        statusDialog.addYesNoButtons();
        statusDialog.pack();
        statusDialog.setVisible(true);
        return statusDialog.getReturnValue();
    }

    public static int showAllOkDialog(ProjectsManager projectsManager, String decisionMessage) {
        StatusDialog statusDialog = new StatusDialog(projectsManager, decisionMessage);
        statusDialog.buildDecisionPanel();
        statusDialog.addYesNoButtons();
        statusDialog.pack();
        statusDialog.setVisible(true);
        return statusDialog.getReturnValue();
    }

    public static void showLoadingFailureDialog(ProjectsManager projectsManager, String failureMessage, List<UserProjectInfo> failPrjs, String conclusionMessage) {
        ArrayList<ProjectsManagerData> failPrjList = new ArrayList<ProjectsManagerData>();
        for (UserProjectInfo prj : failPrjs) {
            failPrjList.add(new ProjectsManagerData(prj.getProjectId(), prj.getProjectName(), prj.getOwnerId()));
        }
        StatusDialog statusDialog = new StatusDialog(projectsManager, failureMessage, failPrjList, conclusionMessage);
        statusDialog.buildProjectMessagePanel(false);
        statusDialog.buildProjectListPanel(false);
        statusDialog.buildDecisionPanel();
        statusDialog.addOkButtons();
        statusDialog.pack();
        GUIUtils.centerOnScreen((Window)statusDialog);
        statusDialog.setVisible(true);
    }

    private int getReturnValue() {
        return this.returnValue;
    }
}

