/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.models;

import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.logic.ProjectAllocationState;
import javax.swing.ImageIcon;

public enum ProjectSpaceAllocation {
    NO_ALLOCATION(ProjectAllocationState.NO_ALLOCATION, ProjectsManagerUI.NO_ALLOCATION),
    WAITING_ALLOCATION(ProjectAllocationState.WAITING_AREA_ALLOCATION, ProjectsManagerUI.ALLOCATED_BLOCKED),
    WAITING_DEALLOCATION(ProjectAllocationState.WAITING_AREA_FREE, ProjectsManagerUI.WAITING_DEALLOCATION),
    ALLOCATED(ProjectAllocationState.UNLOCKED_WITH_AREA_ALLOCATED, ProjectsManagerUI.ALLOCATED_FREE);

    private final ProjectAllocationState state;
    private final ImageIcon icon;

    private ProjectSpaceAllocation(ProjectAllocationState state, ImageIcon icon) {
        this.state = state;
        this.icon = icon;
    }

    public static final ProjectSpaceAllocation getItemFromSpace(long space) {
        if (space == 0L) {
            return NO_ALLOCATION;
        }
        if (space == -1L) {
            return WAITING_ALLOCATION;
        }
        return ALLOCATED;
    }

    public static final ProjectSpaceAllocation getItemFromAllocationState(ProjectAllocationState projectAllocationState) {
        ProjectSpaceAllocation[] projectSpaceAllocationArray = ProjectSpaceAllocation.values();
        int n = projectSpaceAllocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectSpaceAllocation psa = projectSpaceAllocationArray[n2];
            if (psa.getState() == projectAllocationState) {
                return psa;
            }
            ++n2;
        }
        return null;
    }

    public final ImageIcon getIcon() {
        return this.icon;
    }

    private final String getClassString(String tag) {
        return ProjectsManagerUI.getClassString(((Object)((Object)this)).getClass(), tag);
    }

    private final boolean hasString(String tag) {
        return ProjectsManagerUI.hasClassString(((Object)((Object)this)).getClass(), tag);
    }

    public String getDescription() {
        String tag = String.valueOf(this.name()) + ".description";
        if (this.hasString(tag)) {
            return this.getClassString(tag);
        }
        return null;
    }

    public final String getTitle() {
        String tag = String.valueOf(this.name()) + ".title";
        if (this.hasString(tag)) {
            return this.getClassString(tag);
        }
        return null;
    }

    public boolean isOpenable() {
        return this == NO_ALLOCATION || this == ALLOCATED;
    }

    public ProjectAllocationState getState() {
        return this.state;
    }
}

