/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsynchronization;

import csbase.client.applications.projectsynchronization.ContainerConclusion;
import csbase.client.applications.projectsynchronization.StepProjectSynchronization;
import csbase.client.desktop.LocalTask;
import csbase.logic.ProjectSynchronizationData;
import csbase.logic.ProjectSynchronizationFileInfo;
import csbase.logic.ProjectSynchronizationUnit;
import csbase.logic.applicationservice.ApplicationRegistry;
import csbase.util.StringUtils;
import java.awt.Container;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import tecgraf.javautils.gui.wizard.History;
import tecgraf.javautils.gui.wizard.Step;
import tecgraf.javautils.gui.wizard.WizardException;

public class StepConclusion
extends StepProjectSynchronization {
    private ContainerConclusion containerConclusion;
    private ProjectSynchronizationData data;
    private ApplicationRegistry registry;
    private String error;

    StepConclusion(ApplicationRegistry registry) {
        this.registry = registry;
        this.containerConclusion = new ContainerConclusion();
        this.setConfirmOperation(Step.ConfirmOperation.NOTHING);
    }

    private void appendConclusion(String str) {
        String text = this.containerConclusion.getText();
        text = String.valueOf(text) + str;
        this.containerConclusion.setText(text);
        this.containerConclusion.getEConclusion().setText(String.valueOf(text) + "<BR></BODY></HTML>");
    }

    @Override
    protected boolean canConfirm() {
        return true;
    }

    protected Object confirm(History history) throws WizardException {
        return this.data;
    }

    protected void enter(History history) throws WizardException {
        this.data = (ProjectSynchronizationData)history.get(null, "data");
        this.containerConclusion.getEConclusion().setText("");
        this.containerConclusion.setText("");
        String serverNameA = (String)history.get(null, "serverNameA");
        String serverNameB = (String)history.get(null, "serverNameB");
        if (!this.generateAbsoluteFilenames(this.data.getUnitA(), serverNameA, this.data.getUnitB(), serverNameB)) {
            if (this.error != null) {
                history.addGlobal("error", (Object)this.error);
            }
            return;
        }
        if (!this.generateAbsoluteFilenames(this.data.getUnitB(), serverNameB, this.data.getUnitA(), serverNameA)) {
            if (this.error != null) {
                history.addGlobal("error", (Object)this.error);
            }
            return;
        }
    }

    private boolean generateAbsoluteFilenames(final ProjectSynchronizationUnit unitFrom, String serverNameFrom, ProjectSynchronizationUnit unitTo, String serverNameTo) {
        final ArrayList filenames = new ArrayList();
        final StringBuffer conclusionBuffer = new StringBuffer();
        String msg = MessageFormat.format(this.registry.getString("step5.check"), unitFrom.getProjectId(), serverNameFrom, unitTo.getProjectId(), serverNameTo);
        conclusionBuffer.append(String.valueOf(msg) + "<BR><BR>");
        LocalTask<Void> task = new LocalTask<Void>(){

            protected void performTask() throws Exception {
                Map map = unitFrom.getFiles();
                for (ProjectSynchronizationFileInfo psfi : map.values()) {
                    if (!psfi.getTransfer()) continue;
                    String fileName = psfi.generateAbsoluteFilename();
                    this.setStepText(fileName);
                    filenames.add(fileName);
                }
                this.setStepText(StepConclusion.this.registry.getString("step5.buildingConclusionBuffer"));
                Collections.sort(filenames, StringUtils.getPlainSortComparator());
                for (String filename : filenames) {
                    conclusionBuffer.append(String.valueOf(filename) + "<BR>");
                }
            }
        };
        if (!task.execute(null, this.getTitle(), this.registry.getString("step5.getAbsFilenames"), 0, 0, false, true)) {
            if (!task.wasCancelled()) {
                Exception re = task.getError();
                this.error = re.getMessage();
            }
            return false;
        }
        conclusionBuffer.append("<BR><HR>");
        this.appendConclusion(conclusionBuffer.toString());
        return true;
    }

    @Override
    protected String getConfirmActionName() {
        return this.registry.getString("step5.sinchronize.button");
    }

    @Override
    protected String getConfirmActionTooltip() {
        return this.registry.getString("step5.sinchronize.button.tip");
    }

    protected Container getContainer() {
        return this.containerConclusion.getRootPanel();
    }

    protected String getInstruction() {
        if (this.error == null) {
            return this.registry.getString("instruction.step5");
        }
        return this.error;
    }

    protected String getTitle() {
        return this.registry.getString("title.step5");
    }

    protected Class getNext(History arg0) {
        return null;
    }

    protected void exit(History arg0) {
    }

    public ContainerConclusion getContainerConclusion() {
        return this.containerConclusion;
    }
}

