/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.sgamonitor.columns.util;

public class JobProcessorPair
implements Comparable<JobProcessorPair> {
    private int jobs;
    private int processors;

    public JobProcessorPair(int jobs, int processors) {
        this.jobs = jobs;
        this.processors = processors;
    }

    public int getJobs() {
        return this.jobs;
    }

    public void setJobs(int jobs) {
        this.jobs = jobs;
    }

    public int getProcessors() {
        return this.processors;
    }

    public void setProcessors(int processors) {
        this.processors = processors;
    }

    public double getFactor() {
        return this.processors != 0 ? (double)this.jobs / ((double)this.processors + 0.0) : 0.0;
    }

    public int getFactorAsInt() {
        return (int)Math.round(this.getFactor() * 100.0);
    }

    public String toString() {
        return String.valueOf(this.getJobs()) + "/" + this.getProcessors();
    }

    @Override
    public int compareTo(JobProcessorPair o) {
        double myFactor = this.getFactor();
        double otherFactor = o.getFactor();
        int result = 0;
        if (myFactor < otherFactor) {
            result = -1;
        } else if (myFactor > otherFactor) {
            result = 1;
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.jobs;
        result = 31 * result + this.processors;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobProcessorPair other = (JobProcessorPair)obj;
        if (this.jobs != other.jobs) {
            return false;
        }
        return this.processors == other.processors;
    }
}

