/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.xmlviewer;

import csbase.client.Client;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.ApplicationAboutAction;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationProject;
import csbase.client.applications.xmlviewer.actions.XMLViewerCloseAction;
import csbase.client.applications.xmlviewer.actions.XMLViewerFindAction;
import csbase.client.applications.xmlviewer.actions.XMLViewerLocalOpenAction;
import csbase.client.applications.xmlviewer.actions.XMLViewerProjectOpenAction;
import csbase.client.applications.xmlviewer.actions.XMLViewerRefreshAction;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeAdapter;
import csbase.client.util.charset.CharsetRadioMenu;
import csbase.client.util.charset.CharsetRadioMenuChangeListener;
import csbase.client.util.xmlpanel.XMLPanelStyleInterface;
import csbase.client.util.xmlpanel.XMLStandardPanel;
import csbase.logic.ClientFile;
import csbase.logic.ClientFileType;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class XMLViewer
extends ApplicationProject {
    public static final int STATUS_BAR_TIMEOUT = 5;
    private ClientFile currentFile;
    private boolean isSaved = true;
    private boolean isReadOnly = true;
    private final XMLStandardPanel xmlPanel;
    private final XMLViewerLocalOpenAction openLocalAction;
    private final XMLViewerProjectOpenAction openProjectAction;
    private final ProjectTreeAdapter projectTreeAdapter;
    private final CharsetRadioMenu charsetMenu = new CharsetRadioMenu();
    private final JRadioButtonMenuItem noStyleItem = new JRadioButtonMenuItem();
    private final List<XMLPanelStyleInterface> styles = new ArrayList<XMLPanelStyleInterface>();
    private final HashMap<XMLPanelStyleInterface, JRadioButtonMenuItem> styleItemMap = new HashMap();
    private Charset currentCharset;

    private JMenu buildFileMenu() {
        JMenu menu = new JMenu(this.getMyString("file.menu"));
        menu.add(this.openProjectAction);
        if (this.allowLocalFiles()) {
            menu.add(this.openLocalAction);
        }
        menu.add(new XMLViewerCloseAction(this));
        menu.addSeparator();
        menu.add(new ApplicationExitAction(this));
        return menu;
    }

    private boolean allowLocalFiles() {
        String propName = "allow.local.files";
        boolean flag = this.getBooleanSpecificProperty("allow.local.files", false);
        return flag;
    }

    private JMenu buildOptionMenu() {
        this.charsetMenu.addCharsetChangeListener(new CharsetRadioMenuChangeListener(){

            @Override
            public void charsetChanged(Charset charset) {
                XMLViewer.this.currentCharset = charset;
            }
        });
        this.charsetMenu.setText(this.getMyString("charset.options.menu"));
        JMenu menu = new JMenu(this.getMyString("options.menu"));
        menu.add(this.charsetMenu);
        menu.add(new XMLViewerFindAction(this));
        menu.addSeparator();
        menu.add(new XMLViewerRefreshAction(this));
        return menu;
    }

    private JMenu buildHelpMenu() {
        JMenu helpMenu = new JMenu(this.getMyString("help.menu"));
        helpMenu.add(new ApplicationAboutAction(this));
        return helpMenu;
    }

    private JMenuBar buildMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.buildFileMenu());
        menuBar.add(this.buildOptionMenu());
        JMenu layMenu = this.buildStylesMenu();
        if (layMenu != null) {
            menuBar.add(layMenu);
        }
        menuBar.add(this.buildHelpMenu());
        return menuBar;
    }

    private JToolBar buildToolBar() {
        String appName = this.getName();
        JToolBar toolBar = new JToolBar(appName);
        toolBar.setFloatable(false);
        toolBar.add(this.openProjectAction);
        if (this.allowLocalFiles()) {
            toolBar.add(this.openLocalAction);
        }
        toolBar.addSeparator();
        toolBar.add(new XMLViewerFindAction(this));
        return toolBar;
    }

    private ProjectTreeAdapter buildProjectTreeAdapter() {
        ProjectTreeAdapter pta = new ProjectTreeAdapter(){

            @Override
            public void projectChanged(CommonClientProject proj) {
                XMLViewer.this.closeDependentWindows();
                boolean hasProj = proj != null;
                XMLViewer.this.openProjectAction.setEnabled(hasProj);
                if (!hasProj && XMLViewer.this.currentFile != null) {
                    ClientFileType type = XMLViewer.this.currentFile.getClientFileType();
                    if (type != ClientFileType.REMOTE) {
                        return;
                    }
                    try {
                        XMLViewer.this.resetFile();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        return pta;
    }

    public XMLViewer(String id) throws ApplicationException {
        super(id);
        Client client = Client.getInstance();
        this.currentCharset = client.getSystemDefaultCharset();
        this.projectTreeAdapter = this.buildProjectTreeAdapter();
        String attTitle = this.getMyString("attribute.title");
        String txtTitle = this.getMyString("text.title");
        this.xmlPanel = new XMLStandardPanel(attTitle, txtTitle);
        this.xmlPanel.setSearchPanelVisible(false);
        this.openLocalAction = new XMLViewerLocalOpenAction(this);
        this.openProjectAction = new XMLViewerProjectOpenAction(this);
        this.initConfiguredStylists();
        ApplicationFrame applicationFrame = this.getApplicationFrame();
        JMenuBar menu = this.buildMenuBar();
        applicationFrame.setJMenuBar(menu);
        applicationFrame.setSize(new Dimension(800, 600));
        this.buildMainFrame(applicationFrame);
        this.initProjectListener();
    }

    private void initConfiguredStylists() throws ApplicationException {
        List<String> props = this.getStringListSpecificProperty("style");
        if (props == null) {
            return;
        }
        for (String prop : props) {
            try {
                Class<?> cls = Class.forName(prop);
                Constructor<?> constructor = cls.getConstructor(new Class[0]);
                XMLPanelStyleInterface layout = (XMLPanelStyleInterface)constructor.newInstance(new Object[0]);
                this.styles.add(layout);
            }
            catch (Exception e) {
                throw new ApplicationException(e);
            }
        }
    }

    private JMenu buildStylesMenu() {
        if (this.styles == null || this.styles.size() == 0) {
            return null;
        }
        JMenu stylesMenu = new JMenu();
        stylesMenu.setText(this.getMyString("styles.menu"));
        ButtonGroup grp = new ButtonGroup();
        for (final XMLPanelStyleInterface style : this.styles) {
            String styleName = style.getName();
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XMLViewer.this.xmlPanel.setStyle(style);
                }
            };
            JRadioButtonMenuItem item = new JRadioButtonMenuItem();
            this.styleItemMap.put(style, item);
            item.setAction(action);
            item.setText(styleName);
            grp.add(item);
            stylesMenu.add(item);
        }
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLViewer.this.xmlPanel.setStyle(null);
            }
        };
        String noStyleText = this.getMyString("no.style.item");
        this.noStyleItem.setAction(action);
        this.noStyleItem.setText(noStyleText);
        grp.add(this.noStyleItem);
        stylesMenu.add(this.noStyleItem);
        this.noStyleItem.setSelected(true);
        return stylesMenu;
    }

    private void buildMainFrame(ApplicationFrame applicationFrame) {
        JToolBar toolbar = this.buildToolBar();
        Container contentPane = applicationFrame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.xmlPanel, "Center");
        contentPane.add((Component)toolbar, "North");
    }

    @Override
    public void killApplication() {
        if (this.currentFile != null) {
            try {
                this.currentFile.close(true);
            }
            catch (IOException ioe) {
                this.handleError(ioe);
            }
        }
    }

    public final void handleException(Exception e) {
        ApplicationFrame frame = this.getApplicationFrame();
        String title = this.getName();
        String err = e.getMessage();
        String stackMsg = this.getMyString("exception.stack.message");
        String generalMsg = this.getMyString("exception.error.message");
        String msg = String.valueOf(generalMsg) + "\n" + " \u2022 " + err + "\n\n" + stackMsg;
        if (StandardDialogs.showYesNoDialog((Component)frame, (String)title, (Object)msg) == 0) {
            this.showExceptionStack(e);
        }
    }

    private String getMyString(String tag) {
        return this.getClassString(this.getClass(), tag);
    }

    @Override
    protected boolean userCanKillApplication() {
        if (this.isReadOnly) {
            return true;
        }
        return this.isSaved;
    }

    public void openXML(ClientFile file) throws Exception {
        if (file.size() <= 0L) {
            String err = this.getMyString("empty.file.error");
            throw new IOException(err);
        }
        this.currentFile = file;
        this.xmlPanel.setXMLClientFile(file, null, this.currentCharset);
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                XMLViewer.this.updateTitle();
            }
        });
    }

    @Override
    public void sendMessage(String name, Object value, String senderId) {
        if (value == null) {
            return;
        }
        if (name.equals("PROJECT_FILE")) {
            ClientProjectFile file = (ClientProjectFile)value;
            String fileType = file.getType();
            List<String> fileTypes = this.getFileTypes();
            if (!fileTypes.contains(fileType)) {
                return;
            }
            try {
                this.openXML((ClientFile)file);
                XMLPanelStyleInterface style = this.getTipicalStyle(file.getType());
                this.setStyle(style);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private boolean hasProject() {
        DesktopFrame desktopFrame = DesktopFrame.getInstance();
        ProjectTree projectTree = desktopFrame.getTree();
        if (projectTree == null) {
            return false;
        }
        CommonClientProject project = projectTree.getProject();
        boolean hasProj = project != null;
        return hasProj;
    }

    private void initProjectListener() {
        DesktopFrame desktopFrame = DesktopFrame.getInstance();
        ProjectTree projectTree = desktopFrame.getTree();
        if (projectTree == null) {
            String err = "projectTree == null";
            throw new IllegalStateException("projectTree == null");
        }
        if (this.projectTreeAdapter == null) {
            String err = "projectTreeAdapter == null";
            throw new IllegalStateException("projectTreeAdapter == null");
        }
        projectTree.addProjectTreeListener(this.projectTreeAdapter);
        boolean hasProject = this.hasProject();
        this.openProjectAction.setEnabled(hasProject);
    }

    private void updateTitle() {
        ApplicationFrame frame = this.getApplicationFrame();
        String appName = this.getName();
        if (this.currentFile == null) {
            frame.setTitle(appName);
        } else {
            String path = this.currentFile.getStringPath();
            frame.setTitle(String.valueOf(appName) + " - " + path);
        }
    }

    public void resetFile() {
        try {
            this.xmlPanel.setXMLClientFile(null, null, this.currentCharset);
        }
        catch (Exception e) {
            this.showExceptionStack(e);
        }
        this.currentFile = null;
        this.updateTitle();
    }

    public void showFindPanel() {
        this.xmlPanel.setSearchPanelVisible(true);
    }

    public void refreshAll() {
        this.xmlPanel.refreshAll();
    }

    public XMLPanelStyleInterface getTipicalStyle(String fileType) {
        for (XMLPanelStyleInterface style : this.styles) {
            List<String> fileTypes = style.getTipicalFileTypes();
            if (!fileTypes.contains(fileType)) continue;
            return style;
        }
        return null;
    }

    public void setStyle(XMLPanelStyleInterface style) {
        this.xmlPanel.setStyle(style);
        this.updateStyleMenu(style);
    }

    private void updateStyleMenu(XMLPanelStyleInterface style) {
        if (style == null) {
            this.noStyleItem.setSelected(true);
            return;
        }
        JRadioButtonMenuItem chk = this.styleItemMap.get(style);
        chk.setSelected(true);
    }
}

