/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.xmlviewer.styles;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.xmlviewer.styles.XMLPanelStyle;
import csbase.client.util.xmlpanel.XMLPanelUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import org.w3c.dom.Node;

public class XMLPanelStyleFlow
extends XMLPanelStyle {
    private static final String LABEL = "rotulo";
    private static final String OUTPUT = "saida";
    private static final String INPUT = "entrada";
    private static final String CONNECTION = "conexao";
    private static final String PARAM = "parametro";
    private static final String VERSION = "versao";
    private static final String NODE = "no";
    private static final String ALGORITHM = "algoritmo";
    private static final String ID = "id";
    private static final String NAME = "nome";
    private static final String FLOW = "fluxo";

    @Override
    public String getTreeText(Node node, String textValue, int index) {
        if (textValue.equals(FLOW)) {
            String nTxt = XMLPanelUtils.getAttributeValue(node, NAME);
            return nTxt;
        }
        if (textValue.equals(NODE)) {
            String idTxt = XMLPanelUtils.getAttributeValue(node, ID);
            String nTxt = XMLPanelUtils.getFirstChildAttributeValue(node, ALGORITHM, NAME);
            return "Id:" + idTxt + " - " + nTxt;
        }
        if (textValue.equals(ALGORITHM)) {
            String nTxt = XMLPanelUtils.getAttributeValue(node, NAME);
            String vTxt = XMLPanelUtils.getAttributeValue(node, VERSION);
            return String.valueOf(nTxt) + " (" + vTxt + ")";
        }
        if (textValue.equals(PARAM)) {
            String nTxt = XMLPanelUtils.getAttributeValue(node, NAME);
            String rTxt = XMLPanelUtils.getAttributeValue(node, LABEL);
            return String.valueOf(nTxt) + " - " + rTxt;
        }
        if (textValue.equals(CONNECTION)) {
            String frTxt = XMLPanelUtils.getFirstChildAttributeValue(node, INPUT, NODE);
            String toTxt = XMLPanelUtils.getFirstChildAttributeValue(node, OUTPUT, NODE);
            if (frTxt == null) {
                frTxt = "#ERROR";
            }
            if (toTxt == null) {
                toTxt = "#ERROR";
            }
            return String.valueOf(frTxt) + " \u2192 " + toTxt;
        }
        return textValue;
    }

    @Override
    public ImageIcon getIcon(Node node, String textValue, int index) {
        if (textValue.equals(FLOW)) {
            return ApplicationImages.ICON_FLOW_16;
        }
        if (textValue.equals(NODE)) {
            return ApplicationImages.ICON_FLOW_NODE_16;
        }
        if (textValue.equals(ALGORITHM)) {
            return ApplicationImages.ICON_ALGORITHM_16;
        }
        if (textValue.equals(PARAM)) {
            return ApplicationImages.ICON_PARAMETER_16;
        }
        if (textValue.equals(CONNECTION)) {
            return ApplicationImages.ICON_FLOW_CONNECTION_16;
        }
        return null;
    }

    @Override
    public List<String> getTipicalFileTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("FLX");
        return list;
    }
}

