/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.csdk.v1_0.extras.user;

import csbase.client.csdk.v1_0.core.CSDKAbstractContext;
import csbase.client.csdk.v1_0.extras.user.CSDKUser;
import csbase.client.desktop.RemoteTask;
import csbase.logic.User;
import csbase.logic.UserOutline;
import csdk.v1_0.api.user.IUser;
import csdk.v1_0.api.user.IUserContext;
import csdk.v1_0.api.user.UserException;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public class CSDKUserContext
extends CSDKAbstractContext
implements IUserContext {
    public IUser getCurrentUser() throws UserException {
        User user = User.getLoggedUser();
        if (user == null) {
            return null;
        }
        return new CSDKUser(user);
    }

    public IUser[] getAllUsers(Window window) throws UserException {
        RemoteTask<List<UserOutline>> task = new RemoteTask<List<UserOutline>>(){

            protected void performTask() throws Exception {
                this.setResult(User.getAllOutlines());
            }
        };
        String msg = LNG.get((String)(String.valueOf(CSDKUserContext.class.getSimpleName()) + ".all.users.task"));
        if (!task.execute(window, null, msg)) {
            String errorMsg = LNG.get((String)(String.valueOf(CSDKUserContext.class.getSimpleName()) + ".all.users.error"));
            throw new UserException(errorMsg);
        }
        List outlines = (List)task.getResult();
        ArrayList<CSDKUser> users = new ArrayList<CSDKUser>();
        for (UserOutline outline : outlines) {
            users.add(new CSDKUser(outline));
        }
        return users.toArray(new IUser[users.size()]);
    }

    public IUser getUserByLogin(final String login, Window window) throws UserException {
        if (login == null) {
            String errorMsg = LNG.get((String)(String.valueOf(CSDKUserContext.class.getSimpleName()) + ".null.login.error"));
            throw new UserException(errorMsg);
        }
        RemoteTask<User> task = new RemoteTask<User>(){

            protected void performTask() throws Exception {
                this.setResult(User.getUserByLogin((String)login));
            }
        };
        String msg = LNG.get((String)(String.valueOf(CSDKUserContext.class.getSimpleName()) + ".user.by.login.task"));
        if (!task.execute(window, null, msg)) {
            String errorMsg = LNG.get((String)(String.valueOf(CSDKUserContext.class.getSimpleName()) + ".user.by.login.error"), (Object[])new Object[]{login});
            throw new UserException(errorMsg);
        }
        User user = (User)task.getResult();
        if (user == null) {
            return null;
        }
        return new CSDKUser(user);
    }
}

