/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.csdk.v1_0.filesystem;

import csbase.client.csdk.v1_0.core.CSDKAbstractContext;
import csbase.client.csdk.v1_0.filesystem.CSDKFile;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeAdapter;
import csbase.client.project.ProjectTreeListener;
import csbase.client.project.tasks.CreateFileTask;
import csbase.client.project.tasks.GetFileTask;
import csbase.client.project.tasks.RemoveFilesTask;
import csbase.client.util.filechooser.ClientProjectFileChooserUtil;
import csbase.logic.ClientFile;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.applicationservice.ApplicationRegistry;
import csdk.v1_0.api.filesystem.FileSelectionType;
import csdk.v1_0.api.filesystem.IFile;
import csdk.v1_0.api.filesystem.project.IProjectContext;
import csdk.v1_0.api.filesystem.project.IProjectObserver;
import csdk.v1_0.api.filesystem.project.ProjectException;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public class CSDKProjectContext
extends CSDKAbstractContext
implements IProjectContext {
    private final ProjectTreeListener projectTreeListener;
    private final List<IProjectObserver> projectObservers;
    private ApplicationRegistry registry;

    public CSDKProjectContext(ApplicationRegistry registry) {
        this.registry = registry;
        this.projectObservers = new ArrayList<IProjectObserver>();
        this.projectTreeListener = new ProjectTreeAdapter(){

            @Override
            public void projectChanged(CommonClientProject project) {
                if (project == null) {
                    return;
                }
                String id = project.getId().toString();
                for (IProjectObserver listener : CSDKProjectContext.this.projectObservers) {
                    listener.onProjectOpen(id);
                }
            }

            @Override
            public void projectClosed(CommonClientProject project) {
                if (project == null) {
                    return;
                }
                String id = project.getId().toString();
                for (IProjectObserver listener : CSDKProjectContext.this.projectObservers) {
                    listener.onProjectClose(id);
                }
            }
        };
    }

    @Override
    protected void contextActivated() {
        DesktopFrame frame = DesktopFrame.getInstance();
        ProjectTree projectTree = frame.getTree();
        projectTree.addProjectTreeListener(this.projectTreeListener);
    }

    public IFile browseProjectFileInOpenMode(String[] fileTypes, boolean allowAll, FileSelectionType selectionType, Window frame) throws ProjectException {
        ClientProjectFile file;
        ClientProjectFileChooserUtil.OperationResult result;
        this.checkProjectIsOpen();
        if (selectionType == FileSelectionType.DIRECTORIES_ONLY) {
            result = ClientProjectFileChooserUtil.browseSingleDirectoryInOpenMode(frame, this.registry.getApplicationName(LNG.getLocale()), allowAll);
        } else {
            List<String> types = fileTypes != null ? Arrays.asList(fileTypes) : Collections.emptyList();
            result = ClientProjectFileChooserUtil.browseSingleFileInOpenMode(frame, types, this.registry.getApplicationName(LNG.getLocale()), allowAll);
        }
        if (result != null && (file = result.getClientProjectFile()) != null) {
            CSDKFile csdkFile = new CSDKFile((ClientFile)file);
            return csdkFile;
        }
        return null;
    }

    public IFile[] browseMultipleProjectFilesInOpenMode(String[] fileTypes, boolean allowAll, FileSelectionType selectionType, Window window) throws ProjectException {
        List<ClientProjectFileChooserUtil.OperationResult> results;
        this.checkProjectIsOpen();
        if (selectionType == FileSelectionType.DIRECTORIES_ONLY) {
            results = ClientProjectFileChooserUtil.browseMultipleDirectoriesInOpenMode(window, this.registry.getApplicationName(LNG.getLocale()), allowAll);
        } else {
            List<String> types = fileTypes != null ? Arrays.asList(fileTypes) : Collections.emptyList();
            results = ClientProjectFileChooserUtil.browseMultipleFilesInOpenMode(window, types, this.registry.getApplicationName(LNG.getLocale()), allowAll);
        }
        if (results != null) {
            ArrayList<CSDKFile> csdkFiles = new ArrayList<CSDKFile>();
            for (ClientProjectFileChooserUtil.OperationResult result : results) {
                ClientProjectFile file = result.getClientProjectFile();
                if (file == null) continue;
                csdkFiles.add(new CSDKFile((ClientFile)file));
            }
            return csdkFiles.toArray(new IFile[csdkFiles.size()]);
        }
        return null;
    }

    public IFile browseProjectFileInSaveMode(String[] fileTypes, boolean allowAll, String defaultName, Window frame) throws ProjectException {
        ClientProjectFile file;
        this.checkProjectIsOpen();
        List<String> types = fileTypes != null ? Arrays.asList(fileTypes) : Collections.emptyList();
        ClientProjectFileChooserUtil.OperationResult result = ClientProjectFileChooserUtil.browseSingleFileInSaveMode(frame, types, null, this.registry.getApplicationName(LNG.getLocale()), allowAll, true);
        if (result != null && (file = result.getClientProjectFile()) != null) {
            CSDKFile csdkFile = new CSDKFile((ClientFile)file);
            return csdkFile;
        }
        return null;
    }

    public IFile getProjectFile(String[] path, Window window) throws ProjectException {
        this.checkProjectIsOpen();
        ClientProjectFile file = this.getFile(path, window);
        if (file == null) {
            return null;
        }
        return new CSDKFile((ClientFile)file);
    }

    private ClientProjectFile getFile(String[] path, Window window) {
        DesktopFrame desktop = DesktopFrame.getInstance();
        CommonClientProject project = desktop.getProject();
        ClientProjectFile file = GetFileTask.runTask(window, project, path);
        return file;
    }

    public IFile createProjectFile(String[] path, String name, String fileType, Window window) throws ProjectException {
        this.checkProjectIsOpen();
        DesktopFrame desktop = DesktopFrame.getInstance();
        CommonClientProject project = desktop.getProject();
        ClientProjectFile parent = path == null || path.length == 0 ? project.getRoot() : this.getFile(path, window);
        if (parent == null) {
            return null;
        }
        ClientProjectFile newFile = CreateFileTask.runTask(window, project, parent, name, fileType);
        if (newFile == null) {
            return null;
        }
        return new CSDKFile((ClientFile)newFile);
    }

    public boolean removeProjectFile(String[] path, Window parent) throws ProjectException {
        this.checkProjectIsOpen();
        DesktopFrame desktop = DesktopFrame.getInstance();
        CommonClientProject project = desktop.getProject();
        return RemoveFilesTask.runTask(parent, project, path);
    }

    public String getCurrentProjectId() {
        DesktopFrame desktop = DesktopFrame.getInstance();
        CommonClientProject project = desktop.getProject();
        if (project != null) {
            return project.getId().toString();
        }
        return null;
    }

    public void addProjectObserver(IProjectObserver observer) {
        this.projectObservers.add(observer);
    }

    public void removeProjectObserver(IProjectObserver observer) {
        this.projectObservers.remove(observer);
    }

    @Override
    protected void contextDeactivated() {
        DesktopFrame frame = DesktopFrame.getInstance();
        ProjectTree projectTree = frame.getTree();
        projectTree.removeProjectTreeListener(this.projectTreeListener);
        this.projectObservers.clear();
    }

    private void checkProjectIsOpen() throws ProjectException {
        DesktopFrame desktop = DesktopFrame.getInstance();
        CommonClientProject project = desktop.getProject();
        if (project == null) {
            String errorMsg = LNG.get((String)(String.valueOf(CSDKProjectContext.class.getSimpleName()) + ".project.unavailable.error"));
            throw new ProjectException(errorMsg);
        }
    }
}

