/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.desktop.AbstractNotificationFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.NotificationRecipientsTableModel;
import csbase.client.remote.srvproxies.UserProxy;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.UserOutline;
import csbase.remote.ClientRemoteLocator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.table.SortableTable;

public final class NotificationCompositionFrame
extends AbstractNotificationFrame {
    private final JRadioButton allUsersButton = new JRadioButton();
    private final JRadioButton projectUsersButton = new JRadioButton();
    protected final JCheckBox connectedUsersCheck = new JCheckBox();
    private final JButton selectAllUsersButton = new JButton();
    private JTable usersTable;

    @Override
    protected void preShowInit() {
        this.updateUsers();
        this.updateProjectUsersStatus();
    }

    protected List<UserOutline> getUserIdsList() {
        String msg = LNG.get((String)"notification.message.waiting");
        String title = this.getTitle();
        Vector<UserOutline> allOutlines = UserProxy.getAllOutlines(this.getOwner(), title, msg);
        User loggedUser = User.getLoggedUser();
        UserOutline loggedUserOutline = null;
        try {
            loggedUserOutline = loggedUser.getOutline();
            allOutlines.remove(loggedUserOutline);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return allOutlines;
    }

    private boolean projectHasUsers() {
        CommonClientProject project = this.getOpenedProject();
        if (project == null || !project.isShared()) {
            return false;
        }
        return !project.getUsersRO().isEmpty() || !project.getUsersRW().isEmpty();
    }

    private JTable createUsersTable() {
        SortableTable table = new SortableTable((TableModel)new NotificationRecipientsTableModel());
        table.setRowSelectionAllowed(true);
        table.setSelectionMode(2);
        table.setFillsViewportHeight(true);
        return table;
    }

    private JPanel createUsersTablePanel() {
        this.usersTable = this.createUsersTable();
        JScrollPane tableScrollPane = new JScrollPane(this.usersTable);
        tableScrollPane.setPreferredSize(new Dimension(250, 150));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.allUsersButton.setText(LNG.get((String)"notification.all.users.label"));
        this.projectUsersButton.setText(LNG.get((String)"notification.current.project.users.label"));
        buttonGroup.add(this.allUsersButton);
        buttonGroup.add(this.projectUsersButton);
        this.allUsersButton.setSelected(true);
        this.updateProjectUsersStatus();
        this.allUsersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NotificationCompositionFrame.this.updateUsers();
            }
        });
        this.projectUsersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NotificationCompositionFrame.this.updateUsers();
            }
        });
        this.connectedUsersCheck.setText(LNG.get((String)"notification.connected.users.label"));
        this.connectedUsersCheck.setSelected(true);
        this.connectedUsersCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NotificationCompositionFrame.this.updateUsers();
            }
        });
        this.selectAllUsersButton.setText(LNG.get((String)"notification.selectall.users.label"));
        this.selectAllUsersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int numRows = NotificationCompositionFrame.this.usersTable.getRowCount();
                if (numRows == 0) {
                    return;
                }
                NotificationCompositionFrame.this.usersTable.setRowSelectionInterval(0, numRows - 1);
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        String userTitle = LNG.get((String)"notification.user.label");
        panel.setBorder(BorderFactory.createTitledBorder(userTitle));
        Insets border = new Insets(0, 5, 0, 5);
        GBC gbc = new GBC(0, 0).northwest().insets(border);
        panel.add((Component)this.allUsersButton, gbc);
        gbc = new GBC(0, 1).northwest().insets(border);
        panel.add((Component)this.projectUsersButton, gbc);
        gbc = new GBC(1, 0).height(2).width(2).northwest().insets(0, 5, 0, 10).both();
        panel.add((Component)tableScrollPane, gbc);
        gbc = new GBC(1, 3).northwest().insets(10, 0, 5, 20);
        panel.add((Component)this.connectedUsersCheck, gbc);
        gbc = new GBC(2, 3).east().insets(10, 0, 10, 10).pushx();
        panel.add((Component)this.selectAllUsersButton, gbc);
        return panel;
    }

    private void updateProjectUsersStatus() {
        this.projectUsersButton.setEnabled(this.projectHasUsers());
    }

    @Override
    protected String getWindowTitle() {
        return String.format("%s - %s", LNG.get((String)"notification.composition.title"), LNG.get((String)"SERVER"));
    }

    @Override
    protected void addSubPanels(Container mainPane) {
        GBC gbc = new GBC().both(1.0, 0.5).northwest().insets(10);
        mainPane.add((Component)this.createUsersTablePanel(), gbc);
        JPanel messagePanel = this.createEditionPanel(LNG.get((String)"notification.compose.panel.title"));
        gbc = new GBC(0, 1).both().northwest().insets(0, 10, 10, 10);
        mainPane.add((Component)messagePanel, gbc);
        gbc = new GBC(0, 2).horizontal().bottom(10);
        mainPane.add((Component)this.createButtonsPane(), gbc);
    }

    private CommonClientProject getOpenedProject() {
        return DesktopFrame.getInstance().getProject();
    }

    private void fillUsersTable(List<UserOutline> users) {
        int[] modelIndexes = this.getSelectedModelIndexes();
        NotificationRecipientsTableModel model = (NotificationRecipientsTableModel)this.usersTable.getModel();
        if (users == null) {
            model.setUsers();
        } else {
            List<Integer> selectedUsersIndexes = model.setUsers(users, modelIndexes);
            for (Integer modelIndex : selectedUsersIndexes) {
                int i = this.usersTable.convertRowIndexToView(modelIndex);
                this.usersTable.addRowSelectionInterval(i, i);
            }
        }
    }

    protected Set<UserOutline> getProjectUsersIdsSet() {
        CommonClientProject project = this.getOpenedProject();
        if (project == null) {
            return null;
        }
        HashSet<UserOutline> prjUsers = new HashSet<UserOutline>();
        this.addUserOutlines(prjUsers, project.getUsersRO());
        this.addUserOutlines(prjUsers, project.getUsersRW());
        this.addOwnerOutline(prjUsers, project.getUserId());
        return prjUsers;
    }

    private void addOwnerOutline(Set<UserOutline> prjUsers, Object ownerUserId) {
        Object loggedUserId = User.getLoggedUser().getId();
        if (loggedUserId.equals(ownerUserId)) {
            return;
        }
        try {
            User ownerUser = User.getUser((Object)ownerUserId);
            prjUsers.add(ownerUser.getOutline());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addUserOutlines(Set<UserOutline> prjUsers, Set<Object> usersIds) {
        Object loggedUserId = User.getLoggedUser().getId();
        for (Object userId : usersIds) {
            if (loggedUserId.equals(userId)) continue;
            try {
                User user = User.getUser((Object)userId);
                prjUsers.add(user.getOutline());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void updateUsers() {
        List<UserOutline> usersList = this.allUsersButton.isSelected() ? this.getUserIdsList() : new ArrayList<UserOutline>(this.getProjectUsersIdsSet());
        if (this.connectedUsersCheck.isSelected()) {
            try {
                UserOutline[] connectedUsersArray = ClientRemoteLocator.server.getLoggedUsers();
                List<UserOutline> connectedUsersList = Arrays.asList(connectedUsersArray);
                usersList.retainAll(connectedUsersList);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        this.fillUsersTable(usersList);
    }

    public NotificationCompositionFrame() {
        this.buildUI();
    }

    @Override
    public List<Object> getRecipientsIDs() {
        int[] selectedRows = this.getSelectedModelIndexes();
        NotificationRecipientsTableModel model = (NotificationRecipientsTableModel)this.usersTable.getModel();
        return model.getIDsFor(selectedRows);
    }

    private int[] getSelectedModelIndexes() {
        int[] selectedRows = this.usersTable.getSelectedRows();
        int i = 0;
        while (i < selectedRows.length) {
            selectedRows[i] = this.usersTable.convertRowIndexToModel(selectedRows[i]);
            ++i;
        }
        return selectedRows;
    }

    @Override
    public boolean hasRecipients() {
        return this.usersTable.getSelectedRowCount() > 0;
    }

    @Override
    protected ActionListener getSendButtonActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!NotificationCompositionFrame.this.hasRecipients()) {
                    StandardDialogs.showErrorDialog((Component)NotificationCompositionFrame.this, null, (String)LNG.get((String)"notification.composition.error.noRecipients"));
                    return;
                }
                NotificationCompositionFrame.this.sendMessage(!NotificationCompositionFrame.this.connectedUsersCheck.isSelected());
            }
        };
    }
}

