/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.desktop.AbstractNotificationFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.util.DateTranslator;
import csbase.logic.User;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.StandardDialogs;

public class NotificationReplyFrame
extends AbstractNotificationFrame {
    private boolean showReplyPanel = false;
    private static final String CANCEL_BUTTON_LABEL = LNG.get((String)"notification.cancel.button");
    private static final String CLOSE_BUTTON_LABEL = LNG.get((String)"notification.close.button");
    private final String senderLogin;
    private final String receivedMessage;
    private final Date timestamp;
    private final List<Object> recipientsIDs;
    private boolean senderError;

    public NotificationReplyFrame(String senderLogin, Date date, String receivedMessage) {
        this.senderLogin = senderLogin;
        this.timestamp = date;
        this.receivedMessage = receivedMessage;
        this.recipientsIDs = new ArrayList<Object>();
        this.senderError = false;
        try {
            User sender = User.getUserByLogin((String)senderLogin);
            if (sender != null) {
                this.recipientsIDs.add(sender.getId());
                this.showReplyPanel = true;
            }
        }
        catch (Exception e) {
            StandardDialogs.showErrorDialog((Component)DesktopFrame.getInstance().getDesktopFrame(), (String)"notification.reply.error.title", (String)"notification.reply.error.badSender");
            this.senderError = true;
        }
        this.buildUI();
    }

    @Override
    protected List<Object> getRecipientsIDs() {
        return this.recipientsIDs;
    }

    @Override
    protected ActionListener getSendButtonActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NotificationReplyFrame.this.sendMessage(true);
            }
        };
    }

    @Override
    protected boolean hasRecipients() {
        return !this.senderError;
    }

    @Override
    protected void addSubPanels(Container mainPane) {
        JPanel receivedMsgPane = this.createReceivedMessagePane();
        GBC gbc = new GBC().both().northwest().insets(10);
        mainPane.add((Component)receivedMsgPane, gbc);
        if (this.showReplyPanel) {
            JPanel replyMsgPane = this.createEditionPanel(LNG.get((String)"notification.reply.panel.title"));
            gbc = new GBC(0, 1).both().northwest().insets(0, 10, 10, 10);
            mainPane.add((Component)replyMsgPane, gbc);
        }
        JPanel buttonsPane = this.createButtonsPane(this.showReplyPanel);
        gbc = new GBC(0, 2).center().bottom(10);
        mainPane.add((Component)buttonsPane, gbc);
    }

    private JPanel createReceivedMessagePane() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(LNG.get((String)"notification.compose.panel.title")));
        JLabel senderLabel = new JLabel(String.valueOf(LNG.get((String)"notification.sender.label")) + ':');
        GBC gbc = new GBC(0, 0).west().insets(5, 10, 0, 5);
        panel.add((Component)senderLabel, gbc);
        JLabel senderName = new JLabel(this.senderLogin);
        Font boldFont = senderName.getFont();
        Font plainFont = boldFont.deriveFont(0);
        senderName.setFont(plainFont);
        gbc = new GBC(1, 0).west().insets(5, 0, 0, 30);
        panel.add((Component)senderName, gbc);
        JLabel dateLabel = new JLabel(String.valueOf(LNG.get((String)"notification.date.label")) + ':');
        gbc = new GBC(2, 0).west().insets(5, 0, 0, 5);
        panel.add((Component)dateLabel, gbc);
        JLabel dateText = new JLabel(DateTranslator.getInstance().translate(this.timestamp));
        dateText.setFont(plainFont);
        gbc = new GBC(3, 0).west().top(5);
        panel.add((Component)dateText, gbc);
        JTextArea msgTextArea = new JTextArea();
        msgTextArea.setText(this.receivedMessage);
        msgTextArea.setFont(new Font("Monospaced", 0, 12));
        msgTextArea.setEditable(false);
        msgTextArea.setRows(10);
        msgTextArea.setColumns(80);
        msgTextArea.setCaretPosition(0);
        JScrollPane msgScrollPane = new JScrollPane(msgTextArea);
        gbc = new GBC(0, 1).both().width(4).northwest().insets(10);
        panel.add((Component)msgScrollPane, gbc);
        return panel;
    }

    @Override
    protected void preShowInit() {
        this.closeButton.setText(CLOSE_BUTTON_LABEL);
        this.popUpToggle.setSelected(true);
    }

    @Override
    protected String getWindowTitle() {
        return LNG.get((String)"notification.reply.title");
    }

    @Override
    public void messageTextChanged() {
        if (this.editionArea.getText().isEmpty()) {
            this.closeButton.setText(CLOSE_BUTTON_LABEL);
        } else {
            this.closeButton.setText(CANCEL_BUTTON_LABEL);
        }
    }
}

