/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.externalresources;

import csbase.client.externalresources.LocalFile;
import csbase.util.ZipUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ZipLocalFile
implements LocalFile {
    private byte[] data;
    private String name;

    public ZipLocalFile(String name, File[] files) throws IOException {
        if (files == null || files.length == 0) {
            throw new IllegalArgumentException("Tentando criar um zip vazio");
        }
        this.data = ZipUtils.zipFiles((File[])files);
        this.name = name;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public long getLength() {
        return this.data.length;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAbsolutePath() {
        return this.name;
    }

    @Override
    public OutputStream getOutputStream(boolean append) {
        return null;
    }
}

