/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.commandtable;

import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.algorithms.commands.cache.CommandsFilter;
import csbase.client.algorithms.commands.cache.events.AbstractCacheUpdatedEventListener;
import csbase.client.desktop.RemoteTask;
import csbase.client.facilities.commandtable.CommandMonitoringSet;
import csbase.client.facilities.monitoringtable.MonitoringTableEvent;
import csbase.client.facilities.monitoringtable.MonitoringTableObserver;
import csbase.client.util.CodeBlockLog;
import csbase.logic.CommandInfo;
import csbase.logic.MonitoringSet;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.SwingThreadDispatcher;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;
import tecgraf.javautils.gui.table.SortableTable;

public abstract class AbstractCommandMonitoringTable
extends SortableTable {
    private static Logger LOGGER = Logger.getLogger(AbstractCommandMonitoringTable.class.getName());
    private final AtomicBoolean running;
    private final AbstractCacheUpdatedEventListener listener;
    protected ObjectTableModel<CommandMonitoringSet> model;
    private final Collection<MonitoringTableObserver> observers;
    protected boolean showProgressColumn;
    private long cellsEditingMinTime;
    private long cellEditingBeginTime;

    public AbstractCommandMonitoringTable(CommandsFilter filter) {
        this(0, filter, false);
    }

    public AbstractCommandMonitoringTable(int selectionMode, CommandsFilter filter) {
        this(selectionMode, filter, false);
    }

    public AbstractCommandMonitoringTable(int selectionMode, CommandsFilter filter, boolean showProgress) {
        this.showProgressColumn = showProgress;
        this.running = new AtomicBoolean(false);
        this.cellsEditingMinTime = 120000L;
        this.cellEditingBeginTime = -1L;
        this.listener = new AbstractCacheUpdatedEventListener(filter){

            @Override
            public void eventFired(Collection<CommandInfo> commands) {
                AbstractCommandMonitoringTable.this.reloadTable(commands);
            }

            @Override
            protected void eventInterrupted(Exception exception, String description) {
                AbstractCommandMonitoringTable.this.notifyObservers(new MonitoringTableEvent(-1));
            }
        };
        this.observers = new HashSet<MonitoringTableObserver>();
        this.setSelectionMode(selectionMode);
        this.model = new ObjectTableModel(new Vector(), this.getObjectTableProvider());
        this.setModel((TableModel)this.model);
        this.setRowSelectionAllowed(true);
        TableColumnModel colModel = this.getColumnModel();
        int inx = 0;
        while (inx < colModel.getColumnCount()) {
            TableCellEditor editor;
            TableColumn column = colModel.getColumn(inx);
            TableCellRenderer renderer = this.createTableCellRenderer(inx);
            if (renderer != null) {
                column.setCellRenderer(renderer);
            }
            if ((editor = this.createTableCellEditor(inx)) != null) {
                column.setCellEditor(editor);
            }
            ++inx;
        }
    }

    public void setFilter(CommandsFilter filter) {
        this.listener.setFilter(filter);
    }

    public void setCellsEditingMinTime(long cellsEditingMinTime) {
        this.cellsEditingMinTime = cellsEditingMinTime;
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.initializeData(this.listener.getFilter());
            CommandsCache.getInstance().addEventListener(this.listener);
        }
    }

    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            CommandsCache.getInstance().removeEventListener(this.listener);
        }
    }

    public CommandMonitoringSet getMonitoringSet(int modelRow) {
        return (CommandMonitoringSet)this.model.getRow(modelRow);
    }

    public void addObserver(MonitoringTableObserver o) {
        this.observers.add(o);
    }

    public void removeObserver(MonitoringTableObserver o) {
        this.observers.remove(o);
    }

    public CommandInfo getCommandInfo(int viewRow) {
        int modelRow = this.convertRowIndexToModel(viewRow);
        return this.getMonitoringSet(modelRow).getCommandInfo();
    }

    public CommandInfo[] getSelectedCommands() {
        int[] rows = this.getSelectedRows();
        CommandInfo[] commands = new CommandInfo[rows.length];
        int inx = 0;
        while (inx < rows.length) {
            commands[inx] = this.getCommandInfo(rows[inx]);
            ++inx;
        }
        return commands;
    }

    protected TableCellRenderer createTableCellRenderer(int columnIndex) {
        return null;
    }

    protected TableCellEditor createTableCellEditor(int columnIndex) {
        return null;
    }

    protected abstract ObjectTableProvider getObjectTableProvider();

    private List<CommandMonitoringSet> createMonitoringSets(Collection<CommandInfo> commands) {
        ArrayList<CommandMonitoringSet> monitoringSets = new ArrayList<CommandMonitoringSet>();
        for (CommandInfo command : commands) {
            monitoringSets.add(new CommandMonitoringSet(command));
        }
        return monitoringSets;
    }

    private void initializeData(final CommandsFilter filter) {
        RemoteTask<Collection<CommandInfo>> task = new RemoteTask<Collection<CommandInfo>>(){

            protected void performTask() throws Exception {
                CodeBlockLog log = new CodeBlockLog(Level.FINER, "obtendo dados da tabela", new Object[0]);
                LOGGER.log(log.begin());
                Collection<CommandInfo> data = CommandsCache.getInstance().getCommands(filter);
                LOGGER.log(log.finished());
                this.setResult(data);
            }
        };
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        String taskTitle = LNG.get((String)"AbstractCommandMonitoringTable.title");
        String taskMessage = LNG.get((String)"AbstractCommandMonitoringTable.message");
        long d_dur = System.currentTimeMillis();
        if (task.execute(window, taskTitle, taskMessage)) {
            CodeBlockLog log = new CodeBlockLog(Level.FINER, "recarregando a tabela", new Object[0]);
            LOGGER.log(log.begin());
            this.reloadTable((Collection)task.getResult());
            LOGGER.log(log.finished());
        }
    }

    private void reloadTable(Collection<CommandInfo> commands) {
        final List<CommandMonitoringSet> monitoringSets = this.createMonitoringSets(commands);
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AbstractCommandMonitoringTable.this.getCellEditor() != null && AbstractCommandMonitoringTable.this.cellsEditingMinTime > 0L) {
                    if (AbstractCommandMonitoringTable.this.cellEditingBeginTime == -1L) {
                        AbstractCommandMonitoringTable.this.cellEditingBeginTime = System.currentTimeMillis();
                        return;
                    }
                    if (System.currentTimeMillis() - AbstractCommandMonitoringTable.this.cellEditingBeginTime <= AbstractCommandMonitoringTable.this.cellsEditingMinTime) {
                        return;
                    }
                }
                if (AbstractCommandMonitoringTable.this.cellEditingBeginTime != -1L) {
                    AbstractCommandMonitoringTable.this.cellEditingBeginTime = -1L;
                    return;
                }
                AbstractCommandMonitoringTable.this.setTableData(monitoringSets);
                AbstractCommandMonitoringTable.this.notifyObservers(new MonitoringTableEvent(1));
            }
        });
    }

    private void setTableData(List<CommandMonitoringSet> data) {
        Vector<String> selectedKeys = null;
        if (data.size() > 0 && this.model.getRowCount() > 0) {
            selectedKeys = new Vector<String>();
            int[] selectedRows = this.getSelectedRows();
            if (selectedRows != null && selectedRows.length > 0) {
                int i = 0;
                while (i < selectedRows.length) {
                    int tableIndex = selectedRows[i];
                    int modelIndex = this.convertRowIndexToModel(tableIndex);
                    if (modelIndex >= 0) {
                        CommandMonitoringSet selectedSet = this.getMonitoringSet(modelIndex);
                        selectedKeys.add(selectedSet.getKey());
                    }
                    ++i;
                }
            }
        }
        this.model.setRows(data);
        if (selectedKeys == null) {
            return;
        }
        block1: for (String selectedKey : selectedKeys) {
            int inx = 0;
            while (inx < data.size()) {
                MonitoringSet newSet = data.get(inx);
                if (newSet.getKey().equals(selectedKey)) {
                    int viewIndex = this.convertRowIndexToView(inx);
                    this.addRowSelectionInterval(viewIndex, viewIndex);
                    continue block1;
                }
                ++inx;
            }
        }
    }

    private void notifyObservers(MonitoringTableEvent event) {
        for (MonitoringTableObserver obs : this.observers) {
            obs.update(event);
        }
    }
}

