/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.configurabletable.table;

import csbase.client.facilities.configurabletable.column.IConfigurableColumn;
import csbase.client.facilities.configurabletable.table.ColumnState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import tecgraf.javautils.core.filter.IFilter;

public class ConfigurableTableModel<T>
extends AbstractTableModel {
    private List<T> rows;
    private List<IConfigurableColumn<T>> columns;
    private IFilter<T> filter;
    private List<T> filterableRows;
    private List<IConfigurableColumn<T>> visibleColumns;

    public ConfigurableTableModel(List<IConfigurableColumn<T>> columns, IFilter<T> filter, List<T> rows) {
        if (columns == null) {
            throw new IllegalArgumentException("columns n\u00e3o pode ser nulo.");
        }
        if (columns.size() == 0) {
            throw new IllegalArgumentException("\u00c9 necess\u00e1rio que haja pelo menos uma coluna.");
        }
        if (rows == null) {
            throw new IllegalArgumentException("rows n\u00e3o pode ser nulo.");
        }
        this.columns = columns;
        this.filter = filter;
        this.rows = rows;
        this.visibleColumns = new ArrayList<IConfigurableColumn<T>>();
        this.filterableRows = new ArrayList<T>();
        this.updateFilterableRows();
        this.updateVisibleColums();
    }

    public List<IConfigurableColumn<T>> getColumns() {
        return this.visibleColumns;
    }

    public List<IConfigurableColumn<T>> getAllColumns() {
        return this.columns;
    }

    @Override
    public int getRowCount() {
        return this.filterableRows.size();
    }

    @Override
    public int getColumnCount() {
        return this.visibleColumns.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.visibleColumns.get(columnIndex).getColumnName();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.visibleColumns.get(columnIndex).getColumnClass();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.filterableRows.size()) {
            throw new RuntimeException("N\u00e3o existe objeto para a linha " + rowIndex);
        }
        if (columnIndex >= this.visibleColumns.size()) {
            throw new RuntimeException("N\u00e3o existe coluna com o \u00edndice " + columnIndex);
        }
        T row = this.filterableRows.get(rowIndex);
        IConfigurableColumn<T> column = this.visibleColumns.get(columnIndex);
        return column.getValue(row);
    }

    @Override
    public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
        if (rowIndex >= this.filterableRows.size()) {
            throw new RuntimeException("N\u00e3o existe objeto para a linha " + rowIndex);
        }
        if (columnIndex >= this.visibleColumns.size()) {
            throw new RuntimeException("N\u00e3o existe coluna com o \u00edndice " + columnIndex);
        }
        T row = this.filterableRows.get(rowIndex);
        this.visibleColumns.get(columnIndex).setValue(row, newValue);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (rowIndex >= this.filterableRows.size()) {
            throw new RuntimeException("N\u00e3o existe objeto para a linha " + rowIndex);
        }
        if (columnIndex >= this.visibleColumns.size()) {
            throw new RuntimeException("N\u00e3o existe coluna com o \u00edndice " + columnIndex);
        }
        T row = this.filterableRows.get(rowIndex);
        return this.visibleColumns.get(columnIndex).isEditable(row);
    }

    public IConfigurableColumn<T> getColumn(int columnIndex) {
        return this.visibleColumns.get(columnIndex);
    }

    public void clear() {
        int size = this.rows.size();
        this.rows = new ArrayList<T>();
        if (size > 0) {
            this.fireTableRowsDeleted(0, size - 1);
        }
        this.updateFilterableRows();
    }

    public void setRows(List<T> newRows) {
        if (newRows == null) {
            throw new IllegalArgumentException("newRows n\u00e3o pode ser nulo.");
        }
        this.rows = newRows;
        this.fireTableChanged(new TableModelEvent(this));
        this.updateFilterableRows();
    }

    public void add(T row) {
        this.add(row, true);
    }

    public void addAll(Collection<T> rows) {
        if (rows == null) {
            throw new IllegalArgumentException("rows n\u00e3o pode ser nulo.");
        }
        for (T row : rows) {
            this.add(row, false);
        }
        this.fireTableChanged(new TableModelEvent(this));
        this.updateFilterableRows();
    }

    public boolean remove(T row) {
        if (row == null) {
            throw new IllegalArgumentException("row n\u00e3o pode ser nulo.");
        }
        if (this.rows.contains(row)) {
            int index = this.rows.indexOf(row);
            this.rows.remove(index);
            this.updateFilterableRows();
            this.fireTableRowsDeleted(index, index);
            return true;
        }
        return false;
    }

    public T remove(int rowIndex) {
        T row = this.filterableRows.remove(rowIndex);
        this.rows.remove(row);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
        return row;
    }

    public Collection<T> removeAll(int[] rowIndexes) {
        if (rowIndexes == null) {
            throw new IllegalArgumentException("rowIndexes n\u00e3o pode ser nulo.");
        }
        ArrayList<T> removedRows = new ArrayList<T>();
        if (rowIndexes.length > 0) {
            int start = Integer.MAX_VALUE;
            int end = 0;
            int[] nArray = rowIndexes;
            int n = rowIndexes.length;
            int n2 = 0;
            while (n2 < n) {
                int rowIndex = nArray[n2];
                removedRows.add(this.filterableRows.get(rowIndex));
                start = Math.min(start, rowIndex);
                end = Math.max(end, rowIndex);
                ++n2;
            }
            this.filterableRows.removeAll(removedRows);
            this.rows.removeAll(removedRows);
            this.fireTableRowsDeleted(start, end);
        }
        return removedRows;
    }

    public List<T> getRows() {
        return this.filterableRows;
    }

    public List<T> getAllRows() {
        return this.rows;
    }

    public T getRow(int rowIndex) {
        return this.filterableRows.get(rowIndex);
    }

    public IFilter<T> getFilter() {
        return this.filter;
    }

    public void setFilter(IFilter<T> filter) {
        this.filter = filter;
        this.updateFilterableRows();
    }

    public IConfigurableColumn<T> getColumnById(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id da coluna n\u00e3o pode ser nulo.");
        }
        IConfigurableColumn<T> result = null;
        for (IConfigurableColumn<T> column : this.columns) {
            if (!column.getId().equals(id)) continue;
            result = column;
            break;
        }
        return result;
    }

    @Override
    public void fireTableDataChanged() {
        this.updateVisibleColums();
        this.updateFilterableRows();
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void fireTableStructureChanged() {
        this.updateVisibleColums();
        this.updateFilterableRows();
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public List<ColumnState> getColumnsState() {
        ArrayList<ColumnState> columnsState = new ArrayList<ColumnState>();
        for (IConfigurableColumn<T> column : this.getAllColumns()) {
            columnsState.add(new ColumnState(column.getId(), column.isVisible()));
        }
        return columnsState;
    }

    public void setColumnsState(List<ColumnState> columnsState) {
        if (columnsState != null) {
            for (ColumnState state : columnsState) {
                IConfigurableColumn<T> column = this.getColumnById(state.getColumnId());
                if (column == null) continue;
                column.setVisible(state.isVisible());
            }
        }
    }

    private void add(T row, boolean notify) {
        if (row == null) {
            throw new IllegalArgumentException("row n\u00e3o pode ser nulo.");
        }
        int index = this.rows.indexOf(row);
        if (index != -1) {
            this.rows.set(index, row);
            if (notify) {
                this.fireTableRowsUpdated(index, index);
            }
        } else {
            this.rows.add(row);
            if (notify) {
                index = this.rows.size() - 1;
                this.fireTableRowsInserted(index, index);
            }
        }
        this.updateFilterableRows();
    }

    private void updateFilterableRows() {
        this.filterableRows.clear();
        if (this.filter != null) {
            for (T row : this.rows) {
                if (!this.filter.accept(row)) continue;
                this.filterableRows.add(row);
            }
        } else {
            this.filterableRows.addAll(this.rows);
        }
    }

    private void updateVisibleColums() {
        this.visibleColumns.clear();
        for (IConfigurableColumn<T> column : this.columns) {
            if (!column.isVisible()) continue;
            this.visibleColumns.add(column);
        }
    }
}

