/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.desktop.RemoteTask;
import csbase.client.ias.ModifyUserInfoDialog;
import csbase.client.ias.UserGroupName;
import csbase.client.ias.UserPermissionDefinitionDialog;
import csbase.client.ias.UserRoleDefinitionDialog;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.client.remote.srvproxies.UserGroupProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.User;
import csbase.logic.UserGroup;
import csbase.logic.UserInfo;
import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;

public class AdminModifyUserInfoDialog
extends ModifyUserInfoDialog {
    private JComboBox userGroupComboBox;
    private JCheckBox forceLocalLoginCheckBox;
    private JButton roleButton;
    private JButton permissionButton;

    public AdminModifyUserInfoDialog(Window owner, Object userId) {
        super(owner, userId);
        if (!User.getLoggedUser().isAdmin()) {
            throw new IllegalStateException("loggedUser != admin");
        }
    }

    @Override
    protected JPanel makeMiddlePanel() {
        JPanel panel = super.makeMiddlePanel();
        boolean forceLocalLogin = false;
        Object attribute = this.user.getAttribute("forceLocalLogin");
        if (attribute != null) {
            forceLocalLogin = (Boolean)attribute;
        }
        if (!ClientRemoteMonitor.getInstance().canChangePasswords() && !forceLocalLogin) {
            this.passwordButton = this.makePasswordButton();
            this.passwordButton.setEnabled(this.user.isAdmin());
            panel.add(this.passwordButton);
        }
        this.roleButton = this.makeRoleButton();
        panel.add(this.roleButton);
        this.permissionButton = this.makePermissionButton();
        panel.add(this.permissionButton);
        JComponent[] buttons = new JComponent[]{this.roleButton, this.permissionButton, this.passwordButton};
        GUIUtils.matchPreferredSizes((JComponent[])buttons);
        return panel;
    }

    private JButton makeRoleButton() {
        JButton button = new JButton(LNG.get((String)"IAS_USER_ROLES_BUTTON"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new UserRoleDefinitionDialog(AdminModifyUserInfoDialog.this.userInfoDialog, AdminModifyUserInfoDialog.this.userInfo, AdminModifyUserInfoDialog.this.user, false).showDialog();
                AdminModifyUserInfoDialog.this.enableModifyUserButtonIfAllowed();
            }
        });
        return button;
    }

    private JButton makePermissionButton() {
        JButton button = new JButton(LNG.get((String)"IAS_USER_PERMISSIONS_BUTTON"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new UserPermissionDefinitionDialog(AdminModifyUserInfoDialog.this.userInfoDialog, AdminModifyUserInfoDialog.this.userInfo, AdminModifyUserInfoDialog.this.user, false).showDialog();
                AdminModifyUserInfoDialog.this.enableModifyUserButtonIfAllowed();
            }
        });
        return button;
    }

    @Override
    protected boolean unsavedDataInput() {
        boolean userGroupChanged = false;
        boolean forceLocalLoginChanged = false;
        if (!this.user.isAdmin()) {
            userGroupChanged = this.userGroupChanged();
            if (!ClientRemoteMonitor.getInstance().isLocalLogin()) {
                forceLocalLoginChanged = this.forceLocalLoginChanged();
            }
        }
        return super.unsavedDataInput() || userGroupChanged || forceLocalLoginChanged || this.roleSelectionChanged() || this.permissionSelectionChanged();
    }

    private boolean forceLocalLoginChanged() {
        boolean selectedForceLocalLogin = this.forceLocalLoginCheckBox.isSelected();
        Object forceLocalLoginObj = this.user.getAttribute("forceLocalLogin");
        boolean userForceLocalLogin = false;
        if (forceLocalLoginObj != null) {
            userForceLocalLogin = (Boolean)forceLocalLoginObj;
        }
        return selectedForceLocalLogin ^ userForceLocalLogin;
    }

    private boolean userGroupChanged() {
        UserGroup userGroup;
        UserGroupName selectedGroupName = (UserGroupName)this.userGroupComboBox.getSelectedItem();
        try {
            userGroup = UserGroup.getUserGroup((Object)this.user.getAttribute("unId"));
        }
        catch (Exception e) {
            StandardErrorDialogs.showErrorDialog((Window)this.userInfoDialog, String.valueOf(LNG.get((String)"ERRO")) + " - " + this.dialogTitle, (Throwable)e);
            return false;
        }
        UserGroupName userGroupName = new UserGroupName(userGroup);
        return !selectedGroupName.equals(userGroupName);
    }

    private boolean permissionSelectionChanged() {
        Object[] selectedPermissionIds = (Object[])this.userInfo.getAttribute("permissionIds");
        Arrays.sort(selectedPermissionIds);
        Object[] userPermissionIds = (Object[])this.user.getAttribute("permissionIds");
        Arrays.sort(userPermissionIds);
        return !Arrays.equals(selectedPermissionIds, userPermissionIds);
    }

    private boolean roleSelectionChanged() {
        Object[] selectedRoleIds = (Object[])this.userInfo.getAttribute("roleIds");
        Arrays.sort(selectedRoleIds);
        Object[] userRoleIds = (Object[])this.user.getAttribute("roleIds");
        Arrays.sort(userRoleIds);
        return !Arrays.equals(selectedRoleIds, userRoleIds);
    }

    @Override
    protected void updateUserInfo() {
        super.updateUserInfo();
        if (!this.user.isAdmin()) {
            UserGroupName userGroupName = (UserGroupName)this.userGroupComboBox.getSelectedItem();
            UserGroup userGroup = userGroupName.getUserGroup();
            this.userInfo.setAttribute("unId", userGroup.getId());
            if (!ClientRemoteMonitor.getInstance().isLocalLogin()) {
                Boolean forceLocalLogin = new Boolean(this.forceLocalLoginCheckBox.isSelected());
                this.userInfo.setAttribute("forceLocalLogin", (Object)forceLocalLogin);
            }
        }
    }

    @Override
    protected List<JComponent[]> createDataComponents() {
        List<JComponent[]> components = super.createDataComponents();
        if (!this.user.isAdmin()) {
            JLabel userGroupLabel = new JLabel(LNG.get((String)"IAS_USER_USERGROUP"));
            this.userGroupComboBox = this.makeUserGroupComboBox();
            components.add(new JComponent[]{userGroupLabel, this.userGroupComboBox});
            if (!ClientRemoteMonitor.getInstance().isLocalLogin()) {
                JLabel forceLoginLabel = new JLabel(LNG.get((String)"IAS_USER_AUTHENTICATION"));
                this.forceLocalLoginCheckBox = this.makeForceLocalLoginCheckBox();
                components.add(new JComponent[]{forceLoginLabel, this.forceLocalLoginCheckBox});
            }
        }
        return components;
    }

    @Override
    protected void addDataComponentsListeners() {
        super.addDataComponentsListeners();
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AdminModifyUserInfoDialog.this.fireOnDataChanged();
            }
        };
        if (this.userGroupComboBox != null) {
            this.userGroupComboBox.addItemListener(itemListener);
        }
        if (this.forceLocalLoginCheckBox != null) {
            this.forceLocalLoginCheckBox.addItemListener(itemListener);
        }
    }

    private JCheckBox makeForceLocalLoginCheckBox() {
        final JCheckBox checkBox = new JCheckBox(LNG.get((String)"IAS_USER_FORCE_LOCAL_LOGIN"));
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminModifyUserInfoDialog.this.passwordButton.setEnabled(checkBox.isSelected());
            }
        });
        return checkBox;
    }

    @Override
    protected void fillFieldsWithUserData() {
        super.fillFieldsWithUserData();
        RemoteTask<UserInfo> task = new RemoteTask<UserInfo>(){

            public void performTask() throws Exception {
                if (!AdminModifyUserInfoDialog.this.user.isAdmin()) {
                    AdminModifyUserInfoDialog.this.userInfo.setAttribute("unId", AdminModifyUserInfoDialog.this.user.getAttribute("unId"));
                    AdminModifyUserInfoDialog.this.userInfo.setAttribute("roleIds", (Object)AdminModifyUserInfoDialog.this.user.getRoleIds());
                    AdminModifyUserInfoDialog.this.userInfo.setAttribute("permissionIds", (Object)AdminModifyUserInfoDialog.this.user.getPermissionIds());
                    if (!ClientRemoteMonitor.getInstance().isLocalLogin()) {
                        AdminModifyUserInfoDialog.this.userInfo.setAttribute("forceLocalLogin", AdminModifyUserInfoDialog.this.user.getAttribute("forceLocalLogin"));
                    }
                }
                this.setResult(AdminModifyUserInfoDialog.this.userInfo);
            }
        };
        if (!task.execute(this.userInfoDialog, this.dialogTitle, LNG.get((String)"IAS_WAITING_USER_INFO"))) {
            return;
        }
        this.userInfo = (UserInfo)task.getResult();
        if (!this.user.isAdmin()) {
            Object forceLocalLogin;
            try {
                this.userGroupComboBox.setSelectedItem(new UserGroupName(UserGroup.getUserGroup((Object)this.userInfo.getAttribute("unId"))));
            }
            catch (Exception e) {
                StandardErrorDialogs.showErrorDialog((Window)this.userInfoDialog, LNG.get((String)"IAS_USER_USERGROUP_SELECTION_ERROR"), (Throwable)e);
            }
            if (!ClientRemoteMonitor.getInstance().isLocalLogin() && (forceLocalLogin = this.userInfo.getAttribute("forceLocalLogin")) != null && forceLocalLogin.equals(Boolean.TRUE)) {
                this.forceLocalLoginCheckBox.setSelected(true);
            }
        }
    }

    private JComboBox makeUserGroupComboBox() {
        JComboBox<UserGroupName> combo = new JComboBox<UserGroupName>();
        Vector<UserGroup> userGroups = UserGroupProxy.getAllUserGroups(this.userInfoDialog, this.dialogTitle, LNG.get((String)"IAS_WAITING_ALL_USERGROUPS"));
        if (userGroups == null) {
            throw new IllegalStateException(LNG.get((String)"ias.usergroup.retrieval_error"));
        }
        Collections.sort(userGroups, UserGroup.getNameComparator());
        int userGroupSize = userGroups.size();
        int i = 0;
        while (i < userGroupSize) {
            combo.addItem(new UserGroupName(userGroups.get(i)));
            ++i;
        }
        if (userGroupSize > 0) {
            combo.setSelectedIndex(0);
        }
        combo.setBackground(Color.white);
        return combo;
    }
}

