/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.ias.ManagerPanel;
import csbase.client.ias.PlatformInfoDialog;
import csbase.client.remote.srvproxies.PlatformProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.client.util.SwingObserverWrapper;
import csbase.logic.Platform;
import java.awt.Component;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.table.TableModel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public class PlatformManagerPanel
extends ManagerPanel {
    private JFrame parent;
    private static final int debug = 0;

    @Override
    public void beforeClose() {
        Platform.deleteObserver((Observer)new SwingObserverWrapper(this));
    }

    @Override
    public void add() {
        new PlatformInfoDialog(this.parent);
    }

    @Override
    public void modify(Object id) {
        Platform platform = this.getPlatform(id);
        if (platform == null) {
            return;
        }
        new PlatformInfoDialog(this.parent, platform);
    }

    private Platform getPlatform(Object id) {
        Platform platform = PlatformProxy.getPlatform(this.parent, this.parent.getTitle(), LNG.get((String)"IAS_WAITING_PLATFORM"), id);
        if (platform == null) {
            this.displayError(LNG.get((String)"IAS_PLATMGR_PLATFORM_NOT_FOUND"));
        }
        return platform;
    }

    @Override
    public void delete(Object id) {
        Platform platform = this.getPlatform(id);
        if (platform == null) {
            return;
        }
        String platformName = platform.getName();
        int res = StandardDialogs.showYesNoDialog((Component)this.parent, (String)this.parent.getTitle(), (Object)MessageFormat.format(LNG.get((String)"IAS_PLATMGR_PLATFORM_REMOVAL_CONFIRMATION"), platformName));
        if (res == 0) {
            PlatformProxy.deletePlatform(this.parent, this.parent.getTitle(), MessageFormat.format(LNG.get((String)"IAS_PLATMGR_WAITING_REMOVE_PLATFORM"), platformName), platform.getId());
        }
    }

    protected void displayMessage(String title, String message) {
        StandardDialogs.showInfoDialog((Component)this.parent, (String)title, (Object)message);
    }

    protected void displayError(String message) {
        StandardErrorDialogs.showErrorDialog((Window)this.parent, this.parent.getTitle(), message);
    }

    public PlatformManagerPanel(JFrame parent) {
        this.parent = parent;
        Vector<Object> platforms = PlatformProxy.getAllPlatforms(parent, parent.getTitle(), LNG.get((String)"IAS_WAITING_ADMIN_DATA"));
        if (platforms == null) {
            platforms = new Vector();
        }
        DefaultObjectTableProvider provider = new DefaultObjectTableProvider(){

            public Object[] getCellValues(Object item) {
                Platform platform = (Platform)item;
                if (platform == null) {
                    return null;
                }
                return new Object[]{platform.getId(), platform.getName(), platform.getDescription()};
            }

            public String[] getColumnNames() {
                String[] stringArray = new String[3];
                stringArray[1] = LNG.get((String)"IAS_PLATFORM");
                stringArray[2] = LNG.get((String)"IAS_PLATFORM_DESCRIPTION");
                return stringArray;
            }

            public Class<?>[] getColumnClasses() {
                return new Class[]{Object.class, String.class, String.class};
            }
        };
        ObjectTableModel model = new ObjectTableModel(platforms, (ObjectTableProvider)provider);
        Comparator[] comparatorArray = new Comparator[3];
        comparatorArray[1] = ClientUtilities.getStringComparatorIgnoreCase();
        comparatorArray[2] = ClientUtilities.getStringComparatorIgnoreCase();
        Comparator[] comparators = comparatorArray;
        this.make((TableModel)model, comparators, false);
        Platform.addObserver((Observer)new SwingObserverWrapper(this));
    }
}

