/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.login;

import csbase.client.login.InitialContext;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.exception.CSBaseException;
import csbase.logic.Version;
import java.awt.event.ActionEvent;
import java.util.Locale;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public abstract class AbstractLoginUI {
    private boolean canceled;
    private final Lock continueLock = new ReentrantLock();
    private final Condition continueCondition = this.continueLock.newCondition();

    protected abstract void cancel();

    protected boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    private boolean doLogin(String login, String password, Locale locale) throws CSBaseException {
        ClientRemoteMonitor.getInstance().start(login, password, locale);
        return ClientRemoteMonitor.getInstance().isAlive();
    }

    public final InitialContext execute(Locale defaultLocale) {
        if (SwingThreadDispatcher.isEventDispatchThread()) {
            throw new IllegalStateException("O di\u00e1logo de login n\u00e3o pode ser executado na Thread do Swing.");
        }
        Locale locale = defaultLocale == null ? Locale.getDefault() : defaultLocale;
        this.initializeUI(locale);
        this.continueLock.lock();
        try {
            this.showUI();
            ClientRemoteMonitor.getInstance().getServerLookupThread().start();
            this.continueCondition.awaitUninterruptibly();
        }
        finally {
            this.continueLock.unlock();
        }
        return this.getLoginData();
    }

    protected abstract void initializeUI(Locale var1);

    protected abstract void showUI();

    public abstract void disposeUI();

    public void preClientInitializationException() {
    }

    public abstract InitialContext getLoginData();

    protected abstract void updateUIForLoginStarting();

    protected abstract String getLogin();

    protected abstract String getPassword();

    protected abstract Locale getSelectedLocale();

    protected abstract boolean validateLoginUI();

    protected abstract void updateUIForInvalidLoginInfo();

    protected abstract void updateUIForInvalidClientVersion();

    protected abstract void updateUIForLoginException();

    protected final void login() {
        if (!this.validateLoginUI()) {
            return;
        }
        final String login = this.getLogin();
        final String password = this.getPassword();
        this.updateUIForLoginStarting();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    if (!AbstractLoginUI.this.doLogin(login, password, AbstractLoginUI.this.getSelectedLocale())) {
                        AbstractLoginUI.this.updateUIForInvalidLoginInfo();
                    } else if (!ClientRemoteMonitor.getInstance().isSameVersion()) {
                        AbstractLoginUI.this.updateUIForInvalidClientVersion();
                        System.err.println("Vers\u00e3o cliente: " + Version.getInstance().getName());
                        System.err.println("Vers\u00e3o servidor: " + ClientRemoteMonitor.getInstance().getServer().getVersionName());
                    } else {
                        AbstractLoginUI.this.setCanceled(false);
                        AbstractLoginUI.this.unlock();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AbstractLoginUI.this.updateUIForLoginException();
                }
            }
        };
        t.start();
    }

    public void preClientInitialization() {
    }

    protected final void unlock() {
        this.continueLock.lock();
        try {
            this.continueCondition.signalAll();
        }
        finally {
            this.continueLock.unlock();
        }
    }

    protected abstract void setLogin(String var1);

    protected abstract void setPassword(String var1);

    protected void registerDefaultActions(JFrame frame) {
        KeyStroke okKeyStroke = KeyStroke.getKeyStroke(10, 0);
        this.addStrokeAction(frame, okKeyStroke, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractLoginUI.this.login();
            }
        });
        KeyStroke cancelKeyStroke = KeyStroke.getKeyStroke(27, 0);
        this.addStrokeAction(frame, cancelKeyStroke, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractLoginUI.this.cancel();
            }
        });
        KeyStroke adminLoginCombo = KeyStroke.getKeyStroke(10, 192);
        this.addEasterEggSpeedLogin(frame, adminLoginCombo, "admin");
        KeyStroke userLoginCombo = KeyStroke.getKeyStroke(10, 640);
        this.addEasterEggSpeedLogin(frame, userLoginCombo, System.getenv("USER"));
    }

    private void addEasterEggSpeedLogin(JFrame frame, KeyStroke keyStroke, String login) {
        JRootPane component = frame.getRootPane();
        int condition = 1;
        InputMap inputMap = component.getInputMap(condition);
        ActionMap actionMap = component.getActionMap();
        final String loginText = login;
        AbstractAction userLoginAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (loginText == null || loginText.trim().isEmpty()) {
                    return;
                }
                AbstractLoginUI.this.setLogin(loginText);
                AbstractLoginUI.this.setPassword("1234");
                AbstractLoginUI.this.login();
            }
        };
        String actionMapKey = keyStroke.toString();
        inputMap.put(keyStroke, actionMapKey);
        actionMap.put(actionMapKey, userLoginAction);
    }

    protected void addStrokeAction(JFrame frame, KeyStroke keyStroke, AbstractAction action) {
        JRootPane component = frame.getRootPane();
        int condition = 1;
        InputMap inputMap = component.getInputMap(condition);
        ActionMap actionMap = component.getActionMap();
        String actionMapKey = keyStroke.toString();
        inputMap.put(keyStroke, actionMapKey);
        actionMap.put(actionMapKey, action);
    }
}

