/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.login;

import csbase.logic.LoginInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import tecgraf.javautils.core.lng.LNG;

public class ReloginDialog {
    private JDialog loginDialog;
    private JTextField loginTextField;
    private JTextField passwordTextField;
    private LoginInfo info;
    private final String imagePath;

    private void addComponents(JPanel panel, String label, JComponent component) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(4, 4, 4, 0);
        panel.add((Component)new JLabel(label), constraints);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        panel.add((Component)component, constraints);
    }

    private void cancelButtonPressed() {
        this.info = null;
        this.exit();
    }

    protected JPanel createButtonPanel() {
        JButton loginButton = new JButton(LNG.get((String)"relogin.button.login"));
        loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ReloginDialog.this.loginButtonPressed();
            }
        });
        this.loginDialog.getRootPane().setDefaultButton(loginButton);
        JButton cancelButton = new JButton(LNG.get((String)"relogin.button.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ReloginDialog.this.cancelButtonPressed();
            }
        });
        Dimension buttonDimension = new Dimension(Math.max(loginButton.getPreferredSize().width, cancelButton.getPreferredSize().width), Math.max(loginButton.getPreferredSize().height, cancelButton.getPreferredSize().height));
        loginButton.setPreferredSize(buttonDimension);
        cancelButton.setPreferredSize(buttonDimension);
        JPanel buttonP = new JPanel();
        buttonP.setBorder(new EmptyBorder(5, 0, 5, 0));
        buttonP.add(loginButton);
        buttonP.add(cancelButton);
        return buttonP;
    }

    protected void createGUI() {
        this.loginDialog = this.createLoginDialog();
        JPanel loginPanel = new JPanel(new BorderLayout());
        loginPanel.add((Component)this.createMainPanel(), "Center");
        JLabel statusBar = this.createStatusBarLabel();
        loginPanel.add((Component)statusBar, "South");
        this.loginDialog.getContentPane().add(loginPanel);
        this.loginDialog.pack();
    }

    protected JDialog createLoginDialog() {
        JDialog dialog = new JDialog(null, LNG.get((String)"relogin.title"), true);
        dialog.setResizable(false);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ReloginDialog.this.exit();
            }
        });
        return dialog;
    }

    protected JLabel createLoginImageLabel() {
        Image loginImage = this.getLoginImage();
        if (loginImage == null) {
            return null;
        }
        return new JLabel(new ImageIcon(loginImage));
    }

    protected JPanel createMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JLabel loginImageLabel = this.createLoginImageLabel();
        if (loginImageLabel != null) {
            mainPanel.add((Component)this.createLoginImageLabel(), "West");
        }
        mainPanel.add((Component)this.createTextPanel(), "Center");
        mainPanel.add((Component)this.createButtonPanel(), "South");
        return mainPanel;
    }

    protected JLabel createStatusBarLabel() {
        JLabel label = new JLabel(LNG.get((String)"relogin.message.relogin"));
        label.setBorder(BorderFactory.createLoweredBevelBorder());
        return label;
    }

    protected JPanel createTextPanel() {
        JPanel textPanel = new JPanel(new GridBagLayout());
        this.loginTextField = new JTextField(12);
        this.passwordTextField = new JPasswordField(12);
        String loginText = LNG.get((String)"relogin.label.login");
        String passwdText = LNG.get((String)"relogin.label.password");
        this.addComponents(textPanel, String.valueOf(loginText) + ":", this.loginTextField);
        this.addComponents(textPanel, String.valueOf(passwdText) + ":", this.passwordTextField);
        return textPanel;
    }

    protected void exit() {
        this.loginDialog.setVisible(false);
        this.loginDialog.dispose();
    }

    private Image getImage(String path) {
        if (path != null && !path.equals("")) {
            try {
                URL res = this.getClass().getResource(path);
                ImageIcon icon = new ImageIcon(res);
                return icon.getImage();
            }
            catch (Exception e) {
                System.out.println("Falha na carga de imagem: " + path);
                return null;
            }
        }
        return null;
    }

    protected Image getLoginImage() {
        return this.getImage(this.imagePath);
    }

    public LoginInfo getLoginInfo() {
        return this.info;
    }

    private void loginButtonPressed() {
        String loginText = this.loginTextField.getText();
        String passwordText = this.passwordTextField.getText();
        Locale locale = LNG.getLocale();
        this.info = new LoginInfo(loginText, passwordText, locale);
        this.exit();
    }

    public void setVisible(boolean visible) {
        Dimension wSize = this.loginDialog.getSize();
        Dimension sSize = Toolkit.getDefaultToolkit().getScreenSize();
        int newX = (sSize.width - wSize.width) / 2;
        int newY = (sSize.height - wSize.height) / 2;
        this.loginDialog.setLocation(newX, newY);
        this.loginDialog.setVisible(visible);
    }

    public ReloginDialog(String imagePath) {
        this.imagePath = imagePath;
        this.createGUI();
    }
}

