/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.openbus;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import java.util.Vector;

public class OpenBusApplicationInstanceData {
    private final String appId;
    private final ApplicationType instance;

    public final String getApplicationId() {
        return this.appId;
    }

    public final ApplicationType getApplicationInstance() {
        return this.instance;
    }

    public final String getEventValue() {
        return String.valueOf(this.appId) + ":" + this.instance.getInstanceIndex();
    }

    public static String getApplicationIdFromEventValue(String stringValue) {
        String[] idsFromValue = OpenBusApplicationInstanceData.getIdsFromEventValue(stringValue);
        if (idsFromValue == null) {
            return null;
        }
        String apId = idsFromValue[0];
        return apId;
    }

    public static OpenBusApplicationInstanceData getDataFromEventValue(String stringValue) {
        int iId;
        String[] idsFromValue = OpenBusApplicationInstanceData.getIdsFromEventValue(stringValue);
        if (idsFromValue == null) {
            return null;
        }
        String apId = idsFromValue[0];
        String inId = idsFromValue[0];
        try {
            iId = Integer.parseInt(inId);
        }
        catch (NumberFormatException e) {
            return null;
        }
        ApplicationManager appManager = ApplicationManager.getInstance();
        Vector<ApplicationType> runningApplications = appManager.getRunningApplications(apId);
        if (runningApplications == null) {
            return null;
        }
        for (ApplicationType app : runningApplications) {
            int iIdRun = app.getInstanceIndex();
            if (iIdRun != iId) continue;
            OpenBusApplicationInstanceData data = new OpenBusApplicationInstanceData(apId, app);
            return data;
        }
        return null;
    }

    public static String[] getIdsFromEventValue(String stringValue) {
        if (stringValue == null) {
            String err = "null value not allowed!";
            throw new IllegalArgumentException("null value not allowed!");
        }
        String[] splitted = stringValue.split(":");
        if (splitted == null || splitted.length != 2) {
            return null;
        }
        String arg0 = splitted[0];
        String arg1 = splitted[1];
        if (arg0 == null || arg1 == null) {
            return null;
        }
        String apId = arg0.trim();
        String inId = arg1.trim();
        if (apId.isEmpty() || inId.isEmpty()) {
            return null;
        }
        return new String[]{apId, inId};
    }

    public OpenBusApplicationInstanceData(String appId, ApplicationType instance) {
        if (appId == null || instance == null) {
            String err = "null id/instance not allowed!";
            throw new IllegalArgumentException("null id/instance not allowed!");
        }
        this.appId = appId;
        this.instance = instance;
    }
}

