/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceException;
import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.annotations.Editor;
import csbase.client.preferences.annotations.Hidden;
import csbase.client.preferences.annotations.ReadWrite;
import csbase.client.preferences.annotations.Value;
import csbase.client.preferences.definition.PreferenceDefinition;
import csbase.client.preferences.definition.PreferencePolicy;
import csbase.client.preferences.util.PreferenceBundle;
import csbase.client.preferences.util.PreferencesUtil;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

class DefinitionLoader {
    private static DefinitionLoader instance;
    private static PreferenceBundle generalBundle;

    static DefinitionLoader getInstance() {
        if (instance == null) {
            instance = new DefinitionLoader();
        }
        return instance;
    }

    PreferenceBundle getGeneralBundle() {
        if (generalBundle == null) {
            generalBundle = new PreferenceBundle(){

                @Override
                public String get(String key) {
                    return LNG.get((String)key);
                }

                @Override
                public boolean has(String key) {
                    return LNG.hasKey((String)key);
                }
            };
        }
        return generalBundle;
    }

    void loadAppDefinitions(PreferenceCategory root) {
        ApplicationManager am = ApplicationManager.getInstance();
        for (ApplicationRegistry registry : am.getAllApplicationRegistries()) {
            Class<? extends PreferenceDefinition> enumClass = this.loadAppEnum(registry);
            if (enumClass == null) continue;
            PreferenceBundle appBundle = this.createPreferenceBundle(registry);
            this.buildPreferenceNode(enumClass, root, appBundle);
        }
    }

    void loadDefinition(PreferenceCategory root, Class<? extends PreferenceDefinition> enumClass) {
        this.buildPreferenceNode(enumClass, root, this.getGeneralBundle());
    }

    Class<? extends PreferenceDefinition> loadAppEnum(ApplicationRegistry registry) {
        String enumName = PreferencesUtil.getAppEnumName(registry);
        try {
            Class<?> clazz = Class.forName(enumName);
            this.validateEnum(clazz);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private void buildPreferenceNode(Class<? extends PreferenceDefinition> enumClass, PreferenceCategory parent, PreferenceBundle bundle) {
        PreferenceCategory node = parent.createCategory(enumClass.getName(), bundle);
        PreferenceDefinition[] preferenceDefinitionArray = enumClass.getEnumConstants();
        int n = preferenceDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PreferenceDefinition enumConstant = preferenceDefinitionArray[n2];
            Field field = this.loadField(enumConstant.toString(), enumClass);
            Value valueAnnot = field.getAnnotation(Value.class);
            this.validateAnnotation(valueAnnot, field, enumClass);
            PreferencePolicy policy = this.getPolicy(field);
            PreferenceValue<?> value = this.createPreferenceValue(valueAnnot, enumConstant, policy, bundle);
            if (field.isAnnotationPresent(Editor.class)) {
                this.definePreferenceEditor(field.getAnnotation(Editor.class), value);
            }
            node.addPreference(enumConstant.toString(), value);
            ++n2;
        }
        for (Class<? extends PreferenceDefinition> internalEnum : this.getInternalEnums(enumClass)) {
            this.validateEnum(internalEnum);
            this.buildPreferenceNode(internalEnum, node, bundle);
        }
    }

    private Field loadField(String fieldName, Class<?> enumClass) {
        try {
            Field field = enumClass.getField(fieldName);
            return field;
        }
        catch (Exception e) {
            throw new PreferenceException("N\u00e3o foi poss\u00edvel carregar a constante " + fieldName + " da enumera\u00e7\u00e3o " + enumClass.getName(), e);
        }
    }

    private List<Class<? extends PreferenceDefinition>> getInternalEnums(Class<? extends PreferenceDefinition> enumClass) {
        LinkedList<Class<? extends PreferenceDefinition>> result = new LinkedList<Class<? extends PreferenceDefinition>>();
        AnnotatedElement[] annotatedElementArray = enumClass.getDeclaredClasses();
        int n = annotatedElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> internalClass = annotatedElementArray[n2];
            this.validateEnum(internalClass);
            result.add(internalClass);
            ++n2;
        }
        annotatedElementArray = enumClass.getDeclaredFields();
        n = annotatedElementArray.length;
        n2 = 0;
        while (n2 < n) {
            AnnotatedElement field = annotatedElementArray[n2];
            if (((AccessibleObject)field).getAnnotations().length == 0 && !((Field)field).isSynthetic() && !field.getClass().equals(enumClass)) {
                Class<?> internalClass = ((Field)field).getType();
                this.validateEnum(internalClass);
                result.add(internalClass);
            }
            ++n2;
        }
        return result;
    }

    private PreferencePolicy getPolicy(Field field) {
        PreferencePolicy policy = PreferencePolicy.READ_ONLY;
        if (field.isAnnotationPresent(ReadWrite.class)) {
            policy = PreferencePolicy.READ_WRITE;
        }
        if (field.isAnnotationPresent(Hidden.class)) {
            policy = PreferencePolicy.HIDDEN;
        }
        return policy;
    }

    private PreferenceValue<?> createPreferenceValue(Value valueAnnot, PreferenceDefinition name, PreferencePolicy policy, PreferenceBundle preferenceBundle) {
        try {
            Constructor<PreferenceValue<?>> construtor = valueAnnot.type().getConstructor(PreferenceDefinition.class, String.class, String.class, PreferencePolicy.class, PreferenceBundle.class);
            return construtor.newInstance(new Object[]{name, valueAnnot.defaultValue(), valueAnnot.defaultValue(), policy, preferenceBundle});
        }
        catch (Exception e) {
            throw new PreferenceException("Erro ao criar o objeto que encapsula o valor da prefer\u00eancia " + name, e);
        }
    }

    private <T> void definePreferenceEditor(Editor editorAnnot, PreferenceValue<T> value) {
        Class<? extends PreferenceEditor<?>> editorClass = editorAnnot.value();
        value.setPreferenceEditorClass(editorClass);
    }

    private void validateEnum(Class<?> enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException("Enumera\u00e7\u00e3o n\u00e3o pode ser nula.");
        }
        if (!enumClass.isEnum()) {
            throw new PreferenceException(String.valueOf(enumClass.getName()) + " deveria ser uma enumera\u00e7\u00e3o.");
        }
        boolean implement = false;
        Class<?>[] classArray = enumClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> impl = classArray[n2];
            if (impl.equals(PreferenceDefinition.class)) {
                implement = true;
                break;
            }
            ++n2;
        }
        if (!implement) {
            throw new PreferenceException("Enumera\u00e7\u00e3o " + enumClass.getName() + " deve implementar a interface " + PreferenceDefinition.class.getName());
        }
    }

    private void validateAnnotation(Value valueAnnot, Field field, Class<? extends PreferenceDefinition> enumClass) {
        StringBuilder builder = new StringBuilder();
        builder.append("Anota\u00e7\u00e3o: ");
        builder.append(Value.class.getName());
        builder.append("; Constante: ");
        builder.append(field.getName());
        builder.append("; Enumera\u00e7\u00e3o: ");
        builder.append(enumClass.getName());
        String context = builder.toString();
        if (valueAnnot == null) {
            throw new PreferenceException("Anota\u00e7\u00e3o n\u00e3o definida - " + context);
        }
        if (valueAnnot.type() == null) {
            throw new PreferenceException("Tipo n\u00e3o definido - " + context);
        }
        if (valueAnnot.defaultValue() == null) {
            throw new PreferenceException("Valor default n\u00e3o definido - " + context);
        }
    }

    private PreferenceBundle createPreferenceBundle(final ApplicationRegistry registry) {
        return new PreferenceBundle(){

            @Override
            public String get(String key) {
                String appPrefName = String.valueOf(PreferencesUtil.getAppEnumName(registry)) + ".label";
                if (appPrefName.endsWith(key)) {
                    return ApplicationManager.getInstance().getApplicationName(registry);
                }
                return registry.getString(key);
            }

            @Override
            public boolean has(String key) {
                return registry.hasString(key);
            }
        };
    }

    private DefinitionLoader() {
    }
}

