/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences;

import csbase.client.preferences.PreferenceException;
import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferenceDefinition;
import csbase.client.preferences.definition.PreferencePolicy;
import csbase.client.preferences.types.PVBoolean;
import csbase.client.preferences.types.PVInteger;
import csbase.client.preferences.types.PVString;
import csbase.client.preferences.util.PreferenceBundle;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PreferenceCategory {
    static String ROOT_ID = "root";
    private String id;
    private PreferenceBundle preferenceBundle;
    private PreferenceCategory original;
    private Map<String, PreferenceValue<?>> preferences;
    private Map<String, PreferenceCategory> children;

    PreferenceCategory(String id, PreferenceBundle preferenceBundle) {
        this(id, preferenceBundle, null);
    }

    PreferenceCategory(String id, PreferenceBundle preferenceBundle, PreferenceCategory original) {
        if (id == null) {
            throw new PreferenceException("Identificador de uma categoria n\u00e3o pode ser nulo.");
        }
        if (preferenceBundle == null) {
            throw new PreferenceException("bundle n\u00e3o pode ser nulo.");
        }
        this.id = id;
        this.preferenceBundle = preferenceBundle;
        this.original = original;
        this.preferences = new LinkedHashMap();
        this.children = new LinkedHashMap<String, PreferenceCategory>();
    }

    public String getId() {
        return this.id;
    }

    public boolean isRoot() {
        return ROOT_ID.equals(this.id);
    }

    public boolean isCopy() {
        return this.original != null;
    }

    public PreferenceCategory getOriginal() {
        return this.original;
    }

    public String getLabel() {
        int lastDot = Math.max(this.getId().lastIndexOf("."), this.getId().lastIndexOf("$"));
        int length = this.getId().length();
        String key = String.valueOf(this.getId().substring(lastDot + 1, length)) + ".label";
        return this.preferenceBundle.get(key);
    }

    public PreferenceCategory getCategory(Class<? extends PreferenceDefinition> enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException("Classe da enumera\u00e7\u00e3o n\u00e3o pode ser nulo.");
        }
        PreferenceCategory child = this.children.get(enumClass.getName());
        if (child == null) {
            throw new PreferenceException("Categoria " + this.getId() + " n\u00e3o possui categoria filha " + enumClass.getName());
        }
        return child;
    }

    public List<PreferenceCategory> getCategories() {
        return new ArrayList<PreferenceCategory>(this.children.values());
    }

    public boolean hasPreference(PreferenceDefinition name) {
        return this.getPreference(name) != null;
    }

    public PreferenceValue<?> getPreference(PreferenceDefinition name) {
        if (name == null) {
            throw new IllegalArgumentException("name n\u00e3o pode ser nulo.");
        }
        return this.preferences.get(name.toString());
    }

    public PVString getPVString(PreferenceDefinition name) {
        return (PVString)this.getPreference(name);
    }

    public PVBoolean getPVBoolean(PreferenceDefinition name) {
        return (PVBoolean)this.getPreference(name);
    }

    public PVInteger getPVInteger(PreferenceDefinition name) {
        return (PVInteger)this.getPreference(name);
    }

    public String getPreferenceAsString(PreferenceDefinition name) {
        try {
            return (String)this.getPVString(name).getValue();
        }
        catch (Exception e) {
            throw new PreferenceException("Valor da prefer\u00eancia " + name + " n\u00e3o \u00e9 String.");
        }
    }

    public Boolean getPreferenceAsBoolean(PreferenceDefinition name) {
        try {
            return (Boolean)this.getPVBoolean(name).getValue();
        }
        catch (Exception e) {
            throw new PreferenceException("Valor da prefer\u00eancia " + name + " n\u00e3o \u00e9 boleano.");
        }
    }

    public Integer getPreferenceAsInt(PreferenceDefinition name) {
        try {
            return (Integer)this.getPVInteger(name).getValue();
        }
        catch (Exception e) {
            throw new PreferenceException("Valor da prefer\u00eancia " + name + " n\u00e3o \u00e9 inteiro.");
        }
    }

    public List<PreferenceValue<?>> getPreferences(PreferencePolicy ... policies) {
        ArrayList result = new ArrayList();
        if (policies != null) {
            block0: for (PreferenceValue<?> value : this.preferences.values()) {
                PreferencePolicy[] preferencePolicyArray = policies;
                int n = policies.length;
                int n2 = 0;
                while (n2 < n) {
                    PreferencePolicy policy = preferencePolicyArray[n2];
                    if (value.getPolicy().equals((Object)policy)) {
                        result.add(value);
                        continue block0;
                    }
                    ++n2;
                }
            }
        }
        return result;
    }

    public boolean hasPreferences(PreferencePolicy ... policies) {
        return !this.getPreferences(policies).isEmpty();
    }

    public PreferenceCategory copy() {
        if (this.isCopy()) {
            throw new PreferenceException("N\u00e3o \u00e9 permitido criar c\u00f3pias de categorias que j\u00e1 s\u00e3o c\u00f3pias.");
        }
        PreferenceCategory copy = new PreferenceCategory(this.id, this.preferenceBundle, this);
        for (Map.Entry<String, PreferenceValue<?>> entry : this.preferences.entrySet()) {
            String name = entry.getKey();
            PreferenceValue<?> value = entry.getValue();
            copy.addPreference(name, (PreferenceValue<?>)value.clone());
        }
        for (PreferenceCategory child : this.children.values()) {
            copy.addChild(child.getId(), child.copy());
        }
        return copy;
    }

    PreferenceCategory createCategory(String categoryId, PreferenceBundle preferenceBundle) {
        PreferenceCategory child = new PreferenceCategory(categoryId, preferenceBundle);
        this.addChild(categoryId, child);
        return child;
    }

    void addChild(String categoryId, PreferenceCategory child) {
        this.children.put(categoryId, child);
    }

    PreferenceCategory getCategory(String categoryId) {
        return this.children.get(categoryId);
    }

    void addPreference(String name, PreferenceValue<?> value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name/value n\u00e3o pode ser null.");
        }
        this.preferences.put(name, value);
    }

    PreferenceValue<?> getPreference(String name) {
        return this.preferences.get(name);
    }

    Map<String, PreferenceValue<?>> getPreferencesMap() {
        return this.preferences;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return super.toString();
    }
}

