/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences;

import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceException;
import csbase.client.preferences.definition.PreferenceDefinition;
import csbase.client.preferences.definition.PreferencePolicy;
import csbase.client.preferences.editors.EmptyEditor;
import csbase.client.preferences.util.PreferenceBundle;
import csbase.client.preferences.util.PreferenceListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public abstract class PreferenceValue<T>
implements Cloneable {
    protected PreferenceDefinition name;
    protected T value;
    protected String defaultValue;
    protected PreferencePolicy policy;
    protected PreferenceBundle preferenceBundle;
    protected Class<? extends PreferenceEditor<T>> preferenceEditorClass;
    protected PreferenceEditor<T> editor;
    protected List<PreferenceListener<T>> listeners;

    public PreferenceValue(PreferenceDefinition name, String value, String defaultValue, PreferencePolicy policy, PreferenceBundle preferenceBundle) {
        if (name == null) {
            throw new IllegalArgumentException("name n\u00e3o pode ser nulo.");
        }
        if (value == null) {
            throw new IllegalArgumentException("value n\u00e3o pode ser nulo.");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("defaultValue n\u00e3o pode ser nulo.");
        }
        if (policy == null) {
            throw new IllegalArgumentException("policy n\u00e3o pode ser nulo.");
        }
        if (preferenceBundle == null) {
            throw new IllegalArgumentException("preferenceBundle n\u00e3o pode ser nulo.");
        }
        this.name = name;
        this.value = this.toValue(value);
        this.defaultValue = defaultValue;
        this.policy = policy;
        this.preferenceBundle = preferenceBundle;
        this.listeners = new ArrayList<PreferenceListener<T>>();
    }

    public PreferenceDefinition getName() {
        return this.name;
    }

    public String getLabel() {
        return this.preferenceBundle.get(String.valueOf(this.name.getClass().getSimpleName()) + "." + this.name + ".label");
    }

    public String getDescription() {
        return this.preferenceBundle.get(String.valueOf(this.name.getClass().getSimpleName()) + "." + this.name + ".description");
    }

    public PreferencePolicy getPolicy() {
        return this.policy;
    }

    public PreferenceBundle getPreferenceBundle() {
        return this.preferenceBundle;
    }

    public PreferenceEditor<T> getEditor() {
        if (this.editor != null) {
            return this.editor;
        }
        if (this.preferenceEditorClass == null) {
            this.editor = new EmptyEditor(this);
        } else {
            try {
                Constructor<PreferenceEditor<T>> construtor = this.preferenceEditorClass.getConstructor(PreferenceValue.class);
                this.editor = construtor.newInstance(this);
            }
            catch (Exception e) {
                throw new PreferenceException("Erro ao criar o objeto que encapsula o editor de uma prefer\u00eancia.", e);
            }
        }
        return this.editor;
    }

    public Class<? extends PreferenceEditor<T>> getPreferenceEditorClass() {
        return this.preferenceEditorClass;
    }

    public T getDefaultValue() {
        return this.toValue(this.defaultValue);
    }

    public T getValue() {
        return this.value;
    }

    public void setPreferenceEditorClass(Class<? extends PreferenceEditor<T>> preferenceEditorClass) {
        this.preferenceEditorClass = preferenceEditorClass;
    }

    public void setValue(T value) {
        if (value == null) {
            throw new IllegalArgumentException("value n\u00e3o pode ser nulo.");
        }
        T old = this.value;
        this.value = value;
        for (PreferenceListener<T> l : this.listeners) {
            l.valueChanged(old, value);
        }
    }

    public void addPreferenceListener(PreferenceListener<T> l) {
        this.listeners.add(l);
    }

    public void removePreferenceListener(PreferenceListener<T> l) {
        this.listeners.remove(l);
    }

    public abstract String getClassName();

    public abstract T toValue(String var1);

    public abstract String toString();

    public abstract PreferenceValue<T> clone();

    void setValueAsStr(String value) {
        T v = this.toValue(value);
        this.setValue(v);
    }

    void setDefaultValueAsStr(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

