/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences.editors;

import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class PVColorEditor
extends PreferenceEditor<Color> {
    public PVColorEditor(PreferenceValue<Color> pv) {
        super(pv);
    }

    @Override
    protected JComponent createComponent() {
        ColorButton button = new ColorButton((Color)this.getValue());
        JColorChooser chooser = new JColorChooser();
        chooser.setPreviewPanel(new JLabel());
        ActionListener ok = this.createOkAction(button, chooser);
        final JDialog dialog = JColorChooser.createDialog(button, "", true, chooser, ok, null);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(true);
            }
        });
        button.setEnabled(this.isEditable());
        return button;
    }

    private ActionListener createOkAction(final ColorButton button, final JColorChooser chooser) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = chooser.getColor();
                PVColorEditor.this.setValue(c);
                PVColorEditor.this.notifyListeners();
                button.setColor(c);
            }
        };
    }

    private class ColorButton
    extends JButton {
        private Color color;

        ColorButton(Color color) {
            super(" ");
            this.color = color;
        }

        void setColor(Color color) {
            this.color = color;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(this.color);
            g.fillRect(5, 5, this.getWidth() - 10, this.getHeight() - 10);
        }
    }
}

