/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.kernel.ClientException;
import csbase.client.project.ClientProjectFileType;
import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeAdapter;
import csbase.client.project.ProjectTreePopupMenu;
import csbase.client.project.action.CommonDirectoryCreationAction;
import csbase.client.project.action.CommonDirectoryRefreshAction;
import csbase.client.project.action.CommonFileChangeStateAction;
import csbase.client.project.action.CommonFileCopyAction;
import csbase.client.project.action.CommonFileCutAction;
import csbase.client.project.action.CommonFileDeleteAction;
import csbase.client.project.action.CommonFileDownloadAction;
import csbase.client.project.action.CommonFileImportAction;
import csbase.client.project.action.CommonFileOpenAction;
import csbase.client.project.action.CommonFilePasteAction;
import csbase.client.project.action.CommonFilePropertiesShowAction;
import csbase.client.project.action.CommonFileRenameAction;
import csbase.client.project.action.CommonFileTypeChangeAction;
import csbase.client.project.action.CommonFileTypeInferAction;
import csbase.client.project.action.CommonFileUpdateAction;
import csbase.client.project.action.CommonMultiSelectionFileTypeChangeAction;
import csbase.client.project.action.DirectorySortExtAction;
import csbase.client.project.action.DirectorySortNameAction;
import csbase.client.project.action.DirectorySortTypeAction;
import csbase.client.project.action.ExportFilesToDirAction;
import csbase.client.project.action.FileUnlockAction;
import csbase.client.project.action.ProjectTreeUpdateAction;
import csbase.client.project.action.SingleFileExportAction;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileFilter;
import csbase.logic.User;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import tecgraf.javautils.core.lng.LNG;

public class BasicProjectTree
extends ProjectTree {
    protected JMenuItem rootCreateDirMenuItem;
    protected JMenuItem rootSortDirMenuItem;
    protected JMenuItem rootRefreshProjectMenuItem;
    protected JMenuItem rootCopyFileMenuItem;
    protected JMenuItem rootPasteFileMenuItem;
    protected JMenuItem rootImportMenuItem;
    protected JMenuItem rootExportMenuItem;
    protected JRadioButtonMenuItem rootSortByNameRadio;
    protected JRadioButtonMenuItem rootSortByExtRadio;
    protected JRadioButtonMenuItem rootSortByTypeRadio;
    protected JMenuItem dirCreateDirMenuItem;
    protected JMenuItem dirSortDirMenuItem;
    protected JMenuItem dirRefreshDirMenuItem;
    protected JMenuItem dirCutFileMenuItem;
    protected JMenuItem dirCopyFileMenuItem;
    protected JMenuItem dirPasteFileMenuItem;
    protected JMenuItem dirRenameFileMenuItem;
    protected JMenuItem dirDeleteFileMenuItem;
    protected JMenuItem dirImportMenuItem;
    protected JMenuItem dirExportMenuItem;
    protected JRadioButtonMenuItem dirSortByNameRadio;
    protected JRadioButtonMenuItem dirSortByExtRadio;
    protected JRadioButtonMenuItem dirSortByTypeRadio;
    protected JMenuItem fileOpenMenuItem;
    protected JMenuItem notepadFileOpenMenuItem;
    protected JMenuItem fileSeeFilePropertiesMenuItem;
    protected JMenuItem fileCutFileMenuItem;
    protected JMenuItem fileCopyFileMenuItem;
    protected JMenuItem fileRenameFileMenuItem;
    protected JMenuItem fileChangeFileTypeMenuItem;
    protected JMenuItem fileInferFileTypeMenuItem;
    protected JMenuItem fileDeleteFileMenuItem;
    protected JMenuItem fileDownloadFileMenuItem;
    protected JMenuItem fileExportFileMenuItem;
    protected JMenuItem fileUpdateFileMenuItem;
    protected JMenu advancedSubmenu;
    protected JMenu msActionsSubmenu;
    protected JMenu fileActionsSubmenu;
    protected JMenu fileOpenWithSubmenu;
    protected JMenuItem fileChangeStateFileMenuItem;
    protected JMenuItem fileUnlockFileMenuItem;
    protected JMenuItem msCutFileMenuItem;
    protected JMenuItem msCopyFileMenuItem;
    protected JMenuItem msDeleteFileMenuItem;
    protected JMenuItem fileMultiSelectionChangeFileTypeMenuItem;
    protected JMenuItem msExportFileMenuItem;

    public BasicProjectTree(Window owner, String title) throws ClientException {
        this(owner, title, null, null);
    }

    public BasicProjectTree(Window owner, String title, CommonClientProject project) throws ClientException {
        this(owner, title, project, null);
    }

    public BasicProjectTree(Window owner, String title, CommonClientProject project, ProjectFileFilter visualFilter) throws ClientException {
        this(owner, title, project, visualFilter, null);
    }

    public BasicProjectTree(Window owner, String title, CommonClientProject project, ProjectFileFilter visualFilter, ProjectFileFilter selectionFilter) throws ClientException {
        super(owner, title, project, visualFilter, selectionFilter);
        try {
            ClientProjectFileType.loadFileTypes(LNG.getLocale());
        }
        catch (Exception e) {
            throw new ClientException(LNG.get((String)"desktop.file_types_error"), e);
        }
        this.addProjectTreeListener(new ProjectTreeAdapter(){

            @Override
            public void popupFileTriggered(ClientProjectFile file) {
                BasicProjectTree.this.configureFileMenu(file);
            }

            @Override
            public void popupDirTriggered(ClientProjectFile dir) {
                BasicProjectTree.this.configureDirMenu(dir);
            }

            @Override
            public void popupMultSelectionTriggered() {
                BasicProjectTree.this.configureMultipleSelectionMenu();
            }

            @Override
            public void popupRootTriggered() {
                BasicProjectTree.this.configureRootMenu();
            }
        });
        this.setPopupRoot(this.createPopupRoot());
        this.setPopupDir(this.createPopupDir());
        this.dirSortByNameRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BasicProjectTree.this.rootSortByNameRadio.setSelected(true);
            }
        });
        this.dirSortByExtRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BasicProjectTree.this.rootSortByExtRadio.setSelected(true);
            }
        });
        this.dirSortByTypeRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BasicProjectTree.this.rootSortByTypeRadio.setSelected(true);
            }
        });
        this.rootSortByNameRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BasicProjectTree.this.dirSortByNameRadio.setSelected(true);
            }
        });
        this.rootSortByExtRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BasicProjectTree.this.dirSortByExtRadio.setSelected(true);
            }
        });
        this.rootSortByTypeRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BasicProjectTree.this.dirSortByTypeRadio.setSelected(true);
            }
        });
        this.setPopupFile(this.createPopupFile());
        this.setPopupMultSelection(this.createPopupMultSelection());
        this.setSingleSelectionMode(false);
    }

    protected JMenuItem createSortDirMenuItem(JRadioButtonMenuItem nameRadio, JRadioButtonMenuItem extRadio, JRadioButtonMenuItem typeRadio) {
        JMenu sortDirMenuItem = new JMenu(LNG.get((String)"PRJ_SORT_DIR"));
        ButtonGroup sortGroup = new ButtonGroup();
        sortGroup.add(nameRadio);
        sortGroup.add(extRadio);
        sortGroup.add(typeRadio);
        nameRadio.setSelected(true);
        ((Container)sortDirMenuItem).add(nameRadio);
        ((Container)sortDirMenuItem).add(extRadio);
        ((Container)sortDirMenuItem).add(typeRadio);
        return sortDirMenuItem;
    }

    protected ProjectTreePopupMenu createPopupRoot() {
        List<JComponent> items = this.createPopupRootMenuItems();
        ProjectTreePopupMenu menu = new ProjectTreePopupMenu();
        for (JComponent item : items) {
            menu.add(item);
        }
        return menu;
    }

    protected List<JComponent> createPopupRootMenuItems() {
        this.rootCreateDirMenuItem = new JMenuItem(new CommonDirectoryCreationAction(this));
        this.rootSortByNameRadio = new JRadioButtonMenuItem(new DirectorySortNameAction(this));
        this.rootSortByExtRadio = new JRadioButtonMenuItem(new DirectorySortExtAction(this));
        this.rootSortByTypeRadio = new JRadioButtonMenuItem(new DirectorySortTypeAction(this));
        this.rootSortDirMenuItem = this.createSortDirMenuItem(this.rootSortByNameRadio, this.rootSortByExtRadio, this.rootSortByTypeRadio);
        this.rootRefreshProjectMenuItem = new JMenuItem(new ProjectTreeUpdateAction(this));
        this.rootCopyFileMenuItem = new JMenuItem(new CommonFileCopyAction(this));
        this.rootPasteFileMenuItem = new JMenuItem(new CommonFilePasteAction(this));
        this.rootImportMenuItem = new JMenuItem(new CommonFileImportAction(this));
        this.rootExportMenuItem = new JMenuItem(new ExportFilesToDirAction(this));
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        list.add(this.rootCreateDirMenuItem);
        list.add(this.rootSortDirMenuItem);
        list.add(this.rootRefreshProjectMenuItem);
        list.add(new JSeparator());
        list.add(this.rootCopyFileMenuItem);
        list.add(this.rootPasteFileMenuItem);
        list.add(new JSeparator());
        list.add(this.rootImportMenuItem);
        list.add(this.rootExportMenuItem);
        return list;
    }

    protected ProjectTreePopupMenu createPopupDir() {
        List<JComponent> items = this.createPopupDirMenuItems();
        ProjectTreePopupMenu menu = new ProjectTreePopupMenu();
        for (JComponent item : items) {
            menu.add(item);
        }
        return menu;
    }

    protected List<JComponent> createPopupDirMenuItems() {
        this.dirCreateDirMenuItem = new JMenuItem(new CommonDirectoryCreationAction(this));
        this.dirSortByNameRadio = new JRadioButtonMenuItem(new DirectorySortNameAction(this));
        this.dirSortByExtRadio = new JRadioButtonMenuItem(new DirectorySortExtAction(this));
        this.dirSortByTypeRadio = new JRadioButtonMenuItem(new DirectorySortTypeAction(this));
        this.dirSortDirMenuItem = this.createSortDirMenuItem(this.dirSortByNameRadio, this.dirSortByExtRadio, this.dirSortByTypeRadio);
        this.dirRefreshDirMenuItem = new JMenuItem(new CommonDirectoryRefreshAction(this));
        this.dirCutFileMenuItem = new JMenuItem(new CommonFileCutAction(this));
        this.dirCopyFileMenuItem = new JMenuItem(new CommonFileCopyAction(this));
        this.dirPasteFileMenuItem = new JMenuItem(new CommonFilePasteAction(this));
        this.dirRenameFileMenuItem = new JMenuItem(new CommonFileRenameAction(this));
        this.dirDeleteFileMenuItem = new JMenuItem(new CommonFileDeleteAction(this));
        this.dirImportMenuItem = new JMenuItem(new CommonFileImportAction(this));
        this.dirExportMenuItem = new JMenuItem(new ExportFilesToDirAction(this));
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        list.add(this.dirCreateDirMenuItem);
        list.add(this.dirSortDirMenuItem);
        list.add(this.dirRefreshDirMenuItem);
        list.add(new JSeparator());
        list.add(this.dirCutFileMenuItem);
        list.add(this.dirCopyFileMenuItem);
        list.add(this.dirPasteFileMenuItem);
        list.add(new JSeparator());
        list.add(this.dirRenameFileMenuItem);
        list.add(this.dirDeleteFileMenuItem);
        list.add(new JSeparator());
        list.add(this.dirImportMenuItem);
        list.add(this.dirExportMenuItem);
        return list;
    }

    protected ProjectTreePopupMenu createPopupFile() {
        List<JComponent> items = this.createPopupFileMenuItems();
        ProjectTreePopupMenu menu = new ProjectTreePopupMenu();
        for (JComponent item : items) {
            menu.add(item);
        }
        return menu;
    }

    protected List<JComponent> createPopupFileMenuItems() {
        this.fileOpenMenuItem = new JMenuItem(new CommonFileOpenAction(this));
        String fileOpenWithTitle = LNG.get((String)"BasicProjectTree.popupmenu.file.open.with");
        this.fileOpenWithSubmenu = new JMenu(fileOpenWithTitle);
        String ntpTitle = LNG.get((String)"BasicProjectTree.open.notepad");
        String ntpId = "notepad";
        CommonFileOpenAction ntpAction = new CommonFileOpenAction(this, "notepad", ntpTitle);
        this.notepadFileOpenMenuItem = new JMenuItem(ntpAction);
        CommonFilePropertiesShowAction propAction = new CommonFilePropertiesShowAction(this);
        this.fileSeeFilePropertiesMenuItem = new JMenuItem(propAction);
        this.fileUpdateFileMenuItem = new JMenuItem(new CommonFileUpdateAction(this));
        this.fileCutFileMenuItem = new JMenuItem(new CommonFileCutAction(this));
        this.fileCopyFileMenuItem = new JMenuItem(new CommonFileCopyAction(this));
        this.fileRenameFileMenuItem = new JMenuItem(new CommonFileRenameAction(this));
        this.fileChangeFileTypeMenuItem = new JMenuItem(new CommonFileTypeChangeAction(this));
        this.fileInferFileTypeMenuItem = new JMenuItem(new CommonFileTypeInferAction(this));
        this.fileDeleteFileMenuItem = new JMenuItem(new CommonFileDeleteAction(this));
        this.fileDownloadFileMenuItem = new JMenuItem(new CommonFileDownloadAction(this));
        this.fileExportFileMenuItem = new JMenuItem(new SingleFileExportAction(this));
        this.fileChangeStateFileMenuItem = new JMenuItem(new CommonFileChangeStateAction(this));
        this.fileUnlockFileMenuItem = new JMenuItem(new FileUnlockAction(this));
        this.advancedSubmenu = new JMenu(LNG.get((String)"BasicProjectTree.popupmenu.advanced"));
        this.advancedSubmenu.add(this.fileChangeStateFileMenuItem);
        this.advancedSubmenu.add(this.fileUnlockFileMenuItem);
        String acTitle = LNG.get((String)"BasicProjectTree.popupmenu.file.actions");
        this.fileActionsSubmenu = new JMenu(acTitle);
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        list.add(this.fileOpenMenuItem);
        list.add(this.notepadFileOpenMenuItem);
        list.add(this.fileActionsSubmenu);
        list.add(new JSeparator());
        list.add(this.fileSeeFilePropertiesMenuItem);
        list.add(new JSeparator());
        list.add(this.fileCutFileMenuItem);
        list.add(this.fileCopyFileMenuItem);
        list.add(new JSeparator());
        list.add(this.fileRenameFileMenuItem);
        list.add(this.fileChangeFileTypeMenuItem);
        list.add(this.fileInferFileTypeMenuItem);
        list.add(this.fileDeleteFileMenuItem);
        list.add(new JSeparator());
        list.add(this.fileDownloadFileMenuItem);
        list.add(this.fileExportFileMenuItem);
        list.add(new JSeparator());
        list.add(this.advancedSubmenu);
        return list;
    }

    protected boolean configureOpenWithActionsSubMenu(String fileType, ClientProjectFile file) {
        ApplicationManager appManager = ApplicationManager.getInstance();
        List<String> appIds = appManager.getApplicationsFromType(fileType);
        if (appIds == null) {
            return false;
        }
        ArrayList<JMenuItem> itens = new ArrayList<JMenuItem>();
        for (String aid : appIds) {
            ApplicationRegistry reg = appManager.getApplicationRegistry(aid);
            Locale locale = appManager.getLocale();
            String name = reg.getApplicationName(locale);
            CommonFileOpenAction ac = new CommonFileOpenAction(this, aid, name);
            JMenuItem item = new JMenuItem(ac);
            item.setIcon(appManager.getApplicationIcon(aid));
            itens.add(item);
        }
        Collections.sort(itens, new Comparator<JMenuItem>(){

            @Override
            public int compare(JMenuItem o1, JMenuItem o2) {
                String t1 = o1.getText();
                String t2 = o2.getText();
                return t1.compareTo(t2);
            }
        });
        for (JMenuItem item : itens) {
            this.fileOpenWithSubmenu.add(item);
        }
        return appIds.size() > 1;
    }

    protected ProjectTreePopupMenu createPopupMultSelection() {
        List<JComponent> items = this.createPopupMultSelectionMenuItems();
        ProjectTreePopupMenu menu = new ProjectTreePopupMenu();
        for (JComponent item : items) {
            menu.add(item);
        }
        return menu;
    }

    protected List<JComponent> createPopupMultSelectionMenuItems() {
        this.msCutFileMenuItem = new JMenuItem(new CommonFileCutAction(this));
        this.msCopyFileMenuItem = new JMenuItem(new CommonFileCopyAction(this));
        this.msDeleteFileMenuItem = new JMenuItem(new CommonFileDeleteAction(this));
        this.fileMultiSelectionChangeFileTypeMenuItem = new JMenuItem(new CommonMultiSelectionFileTypeChangeAction(this));
        this.msExportFileMenuItem = new JMenuItem(new ExportFilesToDirAction(this));
        this.msActionsSubmenu = new JMenu(LNG.get((String)"BasicProjectTree.popupmenu.multselection.actions"));
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        list.add(this.msActionsSubmenu);
        list.add(new JSeparator());
        list.add(this.msCutFileMenuItem);
        list.add(this.msCopyFileMenuItem);
        list.add(new JSeparator());
        list.add(this.fileMultiSelectionChangeFileTypeMenuItem);
        list.add(this.msDeleteFileMenuItem);
        list.add(new JSeparator());
        list.add(this.msExportFileMenuItem);
        return list;
    }

    protected void configureRootMenu() {
        ClientProjectFile selectedFile = this.getSelectedFile();
        boolean rootSelected = selectedFile != null && selectedFile.getParent() == null;
        this.rootCreateDirMenuItem.setEnabled(rootSelected);
        this.rootSortDirMenuItem.setEnabled(true);
        this.rootRefreshProjectMenuItem.setEnabled(this.refreshEnabled);
        this.rootCopyFileMenuItem.setEnabled(rootSelected && this.transferEnabled);
        if (rootSelected && this.transferEnabled && this.hasFileToPaste()) {
            this.rootPasteFileMenuItem.setEnabled(true);
        } else {
            this.rootPasteFileMenuItem.setEnabled(false);
        }
        this.rootImportMenuItem.setEnabled(rootSelected);
    }

    protected void configureDirMenu(ClientProjectFile dir) {
        boolean dirSelected = this.getSelectedFile() == dir;
        this.dirCreateDirMenuItem.setEnabled(dirSelected);
        this.dirSortDirMenuItem.setEnabled(true);
        this.dirRefreshDirMenuItem.setEnabled(this.refreshEnabled);
        this.dirCutFileMenuItem.setEnabled(dirSelected && this.transferEnabled);
        this.dirCopyFileMenuItem.setEnabled(dirSelected && this.transferEnabled);
        if (dirSelected && this.transferEnabled && this.hasFileToPaste()) {
            this.dirPasteFileMenuItem.setEnabled(true);
        } else {
            this.dirPasteFileMenuItem.setEnabled(false);
        }
        this.dirRenameFileMenuItem.setEnabled(dirSelected && this.renameEnabled);
        this.dirDeleteFileMenuItem.setEnabled(dirSelected && this.deleteEnabled);
        this.dirImportMenuItem.setEnabled(dirSelected);
    }

    protected void configureFileMenu(ClientProjectFile file) {
        boolean enabled;
        String type;
        ClientProjectFile selFile;
        boolean isUnderConstruction = file.isUnderConstruction();
        boolean isInferable = file.getType().equals("UNKNOWN");
        this.fileSeeFilePropertiesMenuItem.setEnabled(true);
        this.fileUpdateFileMenuItem.setEnabled(file.isUpdatable());
        this.fileDeleteFileMenuItem.setEnabled(this.deleteEnabled);
        this.fileCutFileMenuItem.setEnabled(!isUnderConstruction && this.transferEnabled);
        this.fileCopyFileMenuItem.setEnabled(!isUnderConstruction && this.transferEnabled);
        this.fileRenameFileMenuItem.setEnabled(!isUnderConstruction && this.renameEnabled);
        this.fileChangeFileTypeMenuItem.setEnabled(!isUnderConstruction);
        this.fileInferFileTypeMenuItem.setEnabled(!isUnderConstruction && isInferable);
        this.fileDownloadFileMenuItem.setEnabled(!isUnderConstruction);
        this.fileExportFileMenuItem.setEnabled(!isUnderConstruction);
        this.fileChangeStateFileMenuItem.setEnabled(isUnderConstruction);
        boolean enableUnlock = this.userCanUnlockFile(file);
        this.fileUnlockFileMenuItem.setEnabled(enableUnlock);
        this.advancedSubmenu.setEnabled(isUnderConstruction || enableUnlock);
        if (this.fileActionsSubmenu != null) {
            this.fileActionsSubmenu.removeAll();
            this.fileActionsSubmenu.setEnabled(false);
            selFile = this.getSelectedFile();
            if (selFile == null) {
                return;
            }
            type = file.getType();
            enabled = this.configureFileActionsSubMenu(this.fileActionsSubmenu, type, file);
            this.fileActionsSubmenu.setEnabled(enabled);
        }
        if (this.fileOpenWithSubmenu != null) {
            this.fileOpenWithSubmenu.removeAll();
            this.fileOpenWithSubmenu.setEnabled(false);
            selFile = this.getSelectedFile();
            if (selFile == null) {
                return;
            }
            type = file.getType();
            enabled = this.configureOpenWithActionsSubMenu(type, file);
            this.fileOpenWithSubmenu.setEnabled(enabled);
        }
    }

    protected boolean userCanUnlockFile(ClientProjectFile file) {
        User user = User.getLoggedUser();
        return file.isLocked() && (this.getProject().getUserId().equals(user.getId()) || user.isAdmin());
    }

    protected boolean configureFileActionsSubMenu(JMenu menu, String type, ClientProjectFile selectedFile) {
        return false;
    }

    protected boolean configureMultSelectionActionsSubMenu(JMenu menu, String type, ClientProjectFile[] selectedFiles) {
        return false;
    }

    protected void configureMultipleSelectionMenu() {
        ClientProjectFile[] selectedFiles = this.getSelectedFiles();
        this.msCutFileMenuItem.setEnabled(!ClientProjectFile.hasFileUnderConstruction((ClientProjectFile[])selectedFiles) && this.transferEnabled);
        this.msCopyFileMenuItem.setEnabled(!ClientProjectFile.hasFileUnderConstruction((ClientProjectFile[])selectedFiles) && this.transferEnabled);
        this.msDeleteFileMenuItem.setEnabled(this.deleteEnabled);
        this.fileMultiSelectionChangeFileTypeMenuItem.setEnabled(!ClientProjectFile.hasDirectories((ClientProjectFile[])selectedFiles));
        if (this.msActionsSubmenu != null) {
            this.msActionsSubmenu.removeAll();
            this.msActionsSubmenu.setEnabled(false);
            ClientProjectFile[] selFiles = this.getSelectedFiles();
            if (selFiles == null || selFiles.length == 0) {
                return;
            }
            ClientProjectFile file0 = selFiles[0];
            String type0 = file0.getType();
            ClientProjectFile[] clientProjectFileArray = selFiles;
            int n = selFiles.length;
            int n2 = 0;
            while (n2 < n) {
                ClientProjectFile f = clientProjectFileArray[n2];
                String type = f.getType();
                if (!type.equals(type0)) {
                    return;
                }
                ++n2;
            }
            boolean enabled = this.configureMultSelectionActionsSubMenu(this.msActionsSubmenu, type0, selFiles);
            this.msActionsSubmenu.setEnabled(enabled);
        }
    }
}

