/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.applications.ApplicationImages;
import csbase.client.project.ClientProjectFileType;
import csbase.logic.ClientProjectFile;
import javax.swing.ImageIcon;
import tecgraf.javautils.core.lng.LNG;

public final class ClientProjectFileProperties {
    public static ImageIcon getImageIcon(ClientProjectFile file) {
        if (file.isMoving()) {
            return ClientProjectFileProperties.getCutImageIcon(file);
        }
        if (file.isDirectory()) {
            if (file.isUpdated()) {
                return ApplicationImages.ICON_FOLDER_16;
            }
            return ApplicationImages.ICON_FOLDEROUTOFDATE_16;
        }
        ClientProjectFileType fileType = ClientProjectFileType.getFileType(file.getType());
        if (file.isUnderConstruction()) {
            return fileType.getUnderConstructionIcon();
        }
        if (!file.isDirectory()) {
            return fileType.getBaseIcon();
        }
        return null;
    }

    public static ImageIcon getCutImageIcon(ClientProjectFile file) {
        if (file.isDirectory()) {
            return ApplicationImages.ICON_FOLDERCUT_16;
        }
        ClientProjectFileType fileType = ClientProjectFileType.getFileType(file.getType());
        return fileType.getCutIcon();
    }

    public static String getAccessMode(ClientProjectFile file) {
        if (file.isUnderConstruction()) {
            return String.valueOf(LNG.get((String)"PRJ_FILE_READ_ONLY")) + " (" + LNG.get((String)"PRJ_UNDER_CONSTRUCTION_FILE") + ")";
        }
        if (!file.isDirectory()) {
            return LNG.get((String)"PRJ_FILE_READ_AND_WRITE");
        }
        return " ";
    }
}

