/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.RemoteTask;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.UserProjectInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public abstract class CommonProjectSelectDialog
extends DesktopComponentDialog {
    private JList projectList;
    private final JButton defaultButton = new JButton();
    private final List<UserProjectInfo> projectInfos = this.getProjects();
    private final boolean singleSelection;

    private void makeDialog() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.makeProjectListPanel(), "Center");
        mainPanel.add((Component)this.makeButtonPanel(), "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CommonProjectSelectDialog.this.close();
            }
        });
        this.getContentPane().add(mainPanel);
        this.pack();
        this.center(this.getOwner());
        this.getRootPane().setDefaultButton(this.defaultButton);
    }

    private List<UserProjectInfo> getProjects() {
        RemoteTask<List<UserProjectInfo>> task = new RemoteTask<List<UserProjectInfo>>(){

            public void performTask() throws Exception {
                this.setResult(CommonProjectSelectDialog.this.getAllProjectNames(User.getLoggedUser().getId()));
            }
        };
        String msg = LNG.get((String)"CommonProjectSelectDialog.info.get.projects");
        if (task.execute(this.getOwner(), this.getTitle(), msg)) {
            return (List)task.getResult();
        }
        return new ArrayList<UserProjectInfo>();
    }

    public List<UserProjectInfo> getSelectedProjects() {
        Object[] selectedProjects;
        ArrayList<UserProjectInfo> list = new ArrayList<UserProjectInfo>();
        Object[] objectArray = selectedProjects = this.projectList.getSelectedValues();
        int n = selectedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            list.add((UserProjectInfo)object);
            ++n2;
        }
        return list;
    }

    private JPanel makeProjectListPanel() {
        int height;
        int width;
        int selectionMode;
        String projectString = LNG.get((String)"CommonProjectSelectDialog.projects");
        JLabel projectLabel = new JLabel(projectString);
        this.projectList = new JList<Object>(this.projectInfos.toArray());
        ListSelectionModel selectionModel = this.projectList.getSelectionModel();
        if (this.singleSelection) {
            selectionMode = 0;
            selectionModel.setSelectionMode(0);
        } else {
            selectionMode = 2;
            selectionModel.setSelectionMode(2);
        }
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CommonProjectSelectDialog.this.handleAction();
                }
            }
        };
        this.projectList.addMouseListener(mouseListener);
        this.projectList.setSelectedIndex(0);
        JScrollPane usersScrollPane = new JScrollPane(this.projectList, 20, 30);
        int defaultWidth = 270;
        int defaultHeight = 130;
        try {
            ConfigurationManager mng = ConfigurationManager.getInstance();
            Configuration cnf = mng.getConfiguration(this.getClass());
            width = cnf.getOptionalIntegerProperty("list.width", 270);
            height = cnf.getOptionalIntegerProperty("list.height", 130);
        }
        catch (Exception e) {
            width = 270;
            height = 130;
        }
        usersScrollPane.setPreferredSize(new Dimension(width, height));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)projectLabel, new GBC(0, 0).west().insets(10, 10, 5, 10));
        panel.add((Component)usersScrollPane, new GBC(0, 1).both().west().insets(0, 10, 5, 10));
        return panel;
    }

    protected List<UserProjectInfo> getAllProjectNames(Object userId) throws Exception {
        return CommonClientProject.getAllProjects((Object)userId);
    }

    protected void setDefaultTextButtonText(String text) {
        this.defaultButton.setText(text);
    }

    protected JPanel makeButtonPanel() {
        String defaultText = LNG.get((String)"CommonProjectSelectDialog.open");
        this.defaultButton.setText(defaultText);
        this.defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonProjectSelectDialog.this.handleAction();
            }
        });
        String cancelText = LNG.get((String)"CommonProjectSelectDialog.cancel");
        JButton cancelButton = new JButton(cancelText);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonProjectSelectDialog.this.close();
            }
        });
        JComponent[] components = new JComponent[]{this.defaultButton, cancelButton};
        GUIUtils.matchPreferredSizes((JComponent[])components);
        JPanel panel = new JPanel();
        panel.add(cancelButton);
        panel.add(this.defaultButton);
        return panel;
    }

    protected abstract void handleAction();

    protected CommonProjectSelectDialog(Window owner, boolean singleSelection) {
        super(owner);
        this.singleSelection = singleSelection;
        Collections.sort(this.projectInfos);
        this.makeDialog();
    }
}

