/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.desktop.LocalTask;
import csbase.client.externalresources.StandaloneLocalFile;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.LNG;

public class ExportTask
extends LocalTask<Void> {
    private static final String EXPORT_TITLE = "PRJ_PROJECT_FILE_EXPORT_TITLE";
    private static final String ERROR_PREFIX = "cabase.title.error";
    private static final String EXPORT_IO_ERROR = "PRJ_PROJECT_FILE_EXPORT_IO_ERROR";
    private static final int BUFFER_SIZE = 49152;
    private static final String EXPORT_STEP = "PRJ_PROJECT_FILE_EXPORT_STEP";
    private Window window;
    private ClientProjectFile rootFile;
    private StandaloneLocalFile targetFile;
    private long totalSize;

    public ExportTask(File targetFile, ClientProjectFile sourceFile, Window window) {
        this(new StandaloneLocalFile(targetFile), sourceFile, window);
    }

    public ExportTask(StandaloneLocalFile targetFile, ClientProjectFile sourceFile, Window window) {
        this.window = window;
        this.rootFile = sourceFile;
        this.targetFile = targetFile;
    }

    @Override
    protected void handleError(Exception error) {
        if (error instanceof IOException) {
            String msg = MessageFormat.format(LNG.get((String)EXPORT_IO_ERROR), this.rootFile.getName());
            StandardErrorDialogs.showErrorDialog(this.window, String.valueOf(LNG.get((String)ERROR_PREFIX)) + " - " + LNG.get((String)EXPORT_TITLE), msg);
            return;
        }
        super.handleError(error);
    }

    protected void performTask() throws Exception {
        this.transfer(this.targetFile, this.rootFile);
    }

    private void transfer(StandaloneLocalFile targetFile, ClientProjectFile sourceFile) throws IOException {
        this.totalSize += sourceFile.size();
        if (sourceFile.isDirectory()) {
            this.transferDirectory(targetFile, sourceFile);
        } else {
            this.transferFile(targetFile, sourceFile);
        }
    }

    private void transferFile(StandaloneLocalFile targetFile, ClientProjectFile sourceFile) throws IOException {
        String msg = MessageFormat.format(LNG.get((String)EXPORT_STEP), sourceFile.getName());
        this.setStepText(msg);
        targetFile.createNewFile();
        BufferedOutputStream out = new BufferedOutputStream(targetFile.getOutputStream(false));
        InputStream in = null;
        try {
            in = sourceFile.getInputStream();
            byte[] buffer = new byte[49152];
            int readBytes = 0;
            while ((readBytes = in.read(buffer)) > 0) {
                out.write(buffer, 0, readBytes);
            }
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private void transferDirectory(StandaloneLocalFile targetDir, ClientProjectFile sourceDir) throws IOException {
        targetDir.mkdir();
        ClientProjectFile[] sourceChildren = sourceDir.getChildren();
        int i = 0;
        while (i < sourceChildren.length) {
            ClientProjectFile sourceChild = sourceChildren[i];
            String targetChildName = String.valueOf(targetDir.getAbsolutePath()) + File.separator + sourceChild.getName();
            StandaloneLocalFile targetChild = new StandaloneLocalFile(new File(targetChildName));
            this.transfer(targetChild, sourceChildren[i]);
            ++i;
        }
    }

    public long getTotalSize() {
        return this.totalSize;
    }
}

