/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.kernel.ClientException;
import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeFactory;
import csbase.client.project.ProjectTreePath;
import csbase.client.project.ProjectTreeSelectionEvent;
import csbase.client.project.ProjectTreeSelectionListener;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileFilter;
import csbase.logic.filters.ProjectFileDirectoryFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;

public class ProjectDirectoryChooser {
    private static final String TITLE = LNG.get((String)"DIR_CHOOSER_TITLE");
    private ProjectTreePath treePath;
    private ProjectTree projectTree;
    private JButton defaultButton;
    private JTextField dirNameText;
    private ProjectTreeSelectionListener treeSelectionListener;
    private Window owner;
    private DesktopComponentDialog dialog;

    public ProjectTreePath getSelectedDirectory() {
        return this.treePath;
    }

    private void buildDialog() {
        JPanel contentPanel = new JPanel(new BorderLayout(0, 5));
        contentPanel.add((Component)new JScrollPane(this.projectTree.getTree()), "Center");
        contentPanel.add((Component)this.makeTextFieldPanel(), "South");
        JPanel mainPanel = new JPanel(new BorderLayout(0, 5));
        mainPanel.add((Component)contentPanel, "Center");
        mainPanel.add((Component)this.makeButtonPanel(), "South");
        this.dialog = new DesktopComponentDialog(this.owner, TITLE);
        this.dialog.getContentPane().add(mainPanel);
        this.dialog.getRootPane().setDefaultButton(this.defaultButton);
    }

    private JPanel makeButtonPanel() {
        JPanel butPanel = new JPanel();
        this.defaultButton = (JButton)butPanel.add(new JButton(LNG.get((String)"DIR_CHOOSER_OPEN")));
        this.defaultButton.setEnabled(false);
        this.defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectDirectoryChooser.this.handleAction();
            }
        });
        JButton cancelButton = (JButton)butPanel.add(new JButton(LNG.get((String)"DIR_CHOOSER_CANCEL")));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectDirectoryChooser.this.treePath = null;
                ProjectDirectoryChooser.this.close();
            }
        });
        ClientUtilities.adjustEqualSizes(this.defaultButton, cancelButton);
        return butPanel;
    }

    private JPanel makeTextFieldPanel() {
        this.dirNameText = new JTextField(30);
        this.dirNameText.setEditable(false);
        this.dirNameText.setText("");
        JComponent[][] components = new JComponent[][]{{new JLabel(LNG.get((String)"DIR_CHOOSER_SELECTED_NAME")), this.dirNameText}};
        JPanel txtPanel = GUIUtils.createBasicGridPanel((JComponent[][])components);
        return txtPanel;
    }

    private void handleAction() {
        ClientProjectFile selectedFile = this.projectTree.getSelectedFile();
        if (selectedFile == null) {
            StandardErrorDialogs.showErrorDialog((Window)this.dialog, String.valueOf(LNG.get((String)"DIR_CHOOSER_ERROR")) + " - " + TITLE, LNG.get((String)"DIR_CHOOSER_NOT_SELECTED_ERROR"));
            return;
        }
        this.treePath = new ProjectTreePath(selectedFile);
        this.close();
    }

    private void close() {
        this.projectTree.removeTreeSelectionListener(this.treeSelectionListener);
        this.projectTree.release();
        this.dialog.close();
    }

    public ProjectDirectoryChooser(final CommonClientProject project, Window owner) throws ClientException {
        this.owner = owner;
        this.projectTree = ProjectTreeFactory.getInstance().makeProjectTree(owner, TITLE, project, (ProjectFileFilter)ProjectFileDirectoryFilter.getInstance());
        this.projectTree.setSingleSelectionMode(true);
        this.treeSelectionListener = new ProjectTreeSelectionListener(){

            @Override
            public void update(ProjectTreeSelectionEvent event) {
                ClientProjectFile[] selectedFiles = event.getSelectedFiles();
                if (selectedFiles.length == 0) {
                    ProjectDirectoryChooser.this.dirNameText.setText("");
                    ProjectDirectoryChooser.this.defaultButton.setEnabled(false);
                } else {
                    String[] filePath = selectedFiles[0].getPath();
                    ProjectDirectoryChooser.this.dirNameText.setText(ProjectTreePath.makePath(project.getName(), "/", filePath));
                    ProjectDirectoryChooser.this.defaultButton.setEnabled(true);
                }
            }
        };
        this.projectTree.addTreeSelectionListener(this.treeSelectionListener);
        this.buildDialog();
        this.show();
    }

    private void show() {
        this.dialog.pack();
        this.dialog.center(this.owner);
        this.dialog.setVisible(true);
    }
}

