/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.desktop.RemoteTask;
import csbase.logic.User;
import csbase.logic.UserOutline;
import csbase.logic.UserProjectInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import tecgraf.javautils.core.lng.LNG;

class ProjectTableModel
extends DefaultTableModel {
    private static final String[] COL_NAMES = new String[]{LNG.get((String)"ProjectTableModel.col.owner"), LNG.get((String)"ProjectTableModel.col.project"), LNG.get((String)"ProjectTableModel.col.permission")};
    private static Class<?>[] COL_CLASSES = new Class[]{UserOutline.class, UserProjectInfo.class, Boolean.class};
    List<RowData> rows;
    List<Boolean> writableProjects;
    private VisibleColumns visibleColumns;

    public ProjectTableModel(List<RowData> projects, VisibleColumns visibleColumns) {
        this.visibleColumns = visibleColumns;
        this.rows = new ArrayList<RowData>();
        this.fillRows(projects);
    }

    public void replaceRows(List<RowData> projects) {
        this.getDataVector().removeAllElements();
        this.fillRows(projects);
        this.fireTableDataChanged();
    }

    public RowData getRow(int rowIndex) {
        if (rowIndex < 0) {
            return null;
        }
        return this.rows.get(rowIndex);
    }

    public void setVisibleColumns(VisibleColumns visibleColumns) {
        if (visibleColumns != this.visibleColumns) {
            this.visibleColumns = visibleColumns;
            this.fireTableStructureChanged();
        }
    }

    @Override
    public String getColumnName(int column) {
        return COL_NAMES[column];
    }

    @Override
    public int getRowCount() {
        return this.rows == null ? 0 : this.rows.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        RowData rowData = this.rows.get(row);
        switch (this.visibleColumns) {
            case NAME: {
                return rowData.project;
            }
            case OWNER_NAME: 
            case OWNER_NAME_PERMISSION: {
                if (column == 0) {
                    return rowData.user.getName();
                }
                if (column == 1) {
                    return rowData.project;
                }
                return this.writableProjects == null ? null : this.writableProjects.get(row);
            }
        }
        throw new AssertionError((Object)("tipo desconhecido " + this.visibleColumns.name()));
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public int getColumnCount() {
        switch (this.visibleColumns) {
            case NAME: {
                return 1;
            }
            case OWNER_NAME: {
                return 2;
            }
            case OWNER_NAME_PERMISSION: {
                return 3;
            }
        }
        throw new AssertionError((Object)("tipo desconhecido " + this.visibleColumns.name()));
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COL_CLASSES[columnIndex];
    }

    private void fillRows(final List<RowData> projects) {
        String msg;
        String title;
        Object userId;
        RemoteTask<List<Boolean>> task;
        this.rows.clear();
        this.rows.addAll(projects);
        this.writableProjects = null;
        if (this.visibleColumns == VisibleColumns.OWNER_NAME_PERMISSION && (task = new RemoteTask<List<Boolean>>(userId = User.getLoggedUser().getId()){
            private final /* synthetic */ Object val$userId;
            {
                this.val$userId = object;
            }

            protected void performTask() throws Exception {
                ArrayList<Object> prjIds = new ArrayList<Object>();
                for (RowData rowData : projects) {
                    prjIds.add(rowData.project.getProjectId());
                }
                ProjectServiceInterface service = ClientRemoteLocator.projectService;
                List result = service.userCanWrite(prjIds, this.val$userId);
                this.setResult(result);
            }
        }).execute(null, title = LNG.get((String)"GENERIC.title.wait"), msg = LNG.get((String)"ProjectTableModel.info.checkinPermissions"))) {
            this.writableProjects = (List)task.getResult();
        }
    }

    static class RowData {
        UserOutline user;
        UserProjectInfo project;

        RowData(UserOutline userInfo, UserProjectInfo projectInfo) {
            this.user = userInfo;
            this.project = projectInfo;
        }
    }

    public static enum VisibleColumns {
        NAME,
        OWNER_NAME,
        OWNER_NAME_PERMISSION;

    }
}

