/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.logic.ClientProjectFile;

public class ProjectTreePath {
    private ClientProjectFile file;
    private String[] path;
    private ClientProjectFile parent;

    public boolean exists() {
        return this.file != null;
    }

    public String[] getPath() {
        return this.file == null ? this.path : this.file.getPath();
    }

    public ClientProjectFile getFile() {
        return this.file;
    }

    public ClientProjectFile getParent() {
        return this.parent;
    }

    public static String makePath(String sep, String[] path) {
        if (sep == null || path == null || path.length <= 0) {
            return "";
        }
        String dir = "";
        int i = 0;
        while (i < path.length - 1) {
            dir = String.valueOf(dir) + path[i] + sep;
            ++i;
        }
        dir = String.valueOf(dir) + path[path.length - 1];
        return dir;
    }

    public static String makePath(String project, String sep, String[] path) {
        if (sep == null || project == null) {
            return "";
        }
        String dir = "[" + project + "] : " + ProjectTreePath.makePath("/", path);
        return dir;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProjectTreePath)) {
            return false;
        }
        String[] path = ((ProjectTreePath)o).getPath();
        String[] thisPath = this.getPath();
        if (thisPath.length != path.length) {
            return false;
        }
        int i = 0;
        while (i < thisPath.length) {
            if (!thisPath[i].equals(path[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        String[] thisPath = this.getPath();
        if (thisPath == null || thisPath.length == 0 || thisPath[0] == null) {
            return "path attribute null or zero".hashCode();
        }
        return thisPath[0].hashCode();
    }

    public String toString() {
        String toString = "";
        String separator = "";
        String[] path = this.getPath();
        int i = 0;
        while (i < path.length) {
            toString = String.valueOf(toString) + separator;
            toString = String.valueOf(toString) + path[i];
            separator = "/";
            ++i;
        }
        return toString;
    }

    public ProjectTreePath(ClientProjectFile file) {
        this.file = file;
        this.parent = file.getParent();
    }

    public ProjectTreePath(String[] path, ClientProjectFile dir) {
        this.path = path;
        this.parent = dir;
    }
}

