/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.applications.ApplicationImages;
import csbase.client.project.ClientProjectFileProperties;
import csbase.client.project.ProjectTreeModel;
import csbase.client.project.ProjectTreeNode;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;

class ProjectTreeRenderer
extends DefaultTreeCellRenderer {
    private static final String PRJ_LOCKED_TOOLTIP;
    private static final String PRJ_OUTOFDATE_TOOLTIP;
    private static final boolean DRAW_PROJECT_SHARING;

    static {
        boolean drawSharing;
        PRJ_LOCKED_TOOLTIP = LNG.get((String)"ProjectTree.locked");
        PRJ_OUTOFDATE_TOOLTIP = LNG.get((String)"ProjectTree.outOfDate");
        try {
            Configuration cfg = ConfigurationManager.getInstance().getConfiguration(ProjectTreeRenderer.class);
            drawSharing = cfg.getOptionalBooleanProperty("draw.project.sharing", false);
        }
        catch (ConfigurationManagerException e) {
            drawSharing = false;
        }
        DRAW_PROJECT_SHARING = drawSharing;
    }

    ProjectTreeRenderer() {
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean isFocused) {
        JLabel component = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, isFocused);
        ProjectTreeNode projectTreeNode = (ProjectTreeNode)value;
        ProjectTreeModel model = (ProjectTreeModel)tree.getModel();
        ClientProjectFile file = projectTreeNode.getClientProjectFile();
        if (value == model.getRoot() && DRAW_PROJECT_SHARING) {
            return this.buildProjectComponent(component, model, file);
        }
        if (file.isDirectory()) {
            if (file.isUpdated()) {
                component.setToolTipText(null);
            } else {
                component.setToolTipText(PRJ_OUTOFDATE_TOOLTIP);
            }
        } else {
            try {
                ProjectFileType type = ProjectFileType.getFileType((String)file.getType());
                component.setToolTipText(type.getDescription());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (file.isLocked()) {
                component.setForeground(Color.RED);
                component.setToolTipText(PRJ_LOCKED_TOOLTIP);
            }
        }
        component.setIcon(ClientProjectFileProperties.getImageIcon(file));
        return component;
    }

    private Component buildProjectComponent(JLabel component, ProjectTreeModel model, ClientProjectFile file) {
        JLabel[] labels;
        CommonClientProject project = model.getProject();
        if (project == null) {
            return component;
        }
        JLabel sharedLabel = new JLabel();
        if (project.isPrivate()) {
            sharedLabel.setIcon(ApplicationImages.ICON_PRIVATE_16);
        } else if (project.isPublic()) {
            sharedLabel.setIcon(ApplicationImages.ICON_PUBLIC_16);
        } else {
            sharedLabel.setIcon(ApplicationImages.ICON_SHARED_16);
        }
        Font fnt = component.getFont();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        component.setIcon(ClientProjectFileProperties.getImageIcon(file));
        JLabel lb1 = new JLabel("(");
        JLabel lb2 = new JLabel(")");
        Color fg = component.getForeground();
        Color bg = component.getBackground();
        JLabel[] jLabelArray = labels = new JLabel[]{lb1, lb2, sharedLabel};
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            JLabel label = jLabelArray[n2];
            label.setFont(fnt);
            label.setForeground(fg);
            label.setBackground(bg);
            ++n2;
        }
        panel.add((Component)component, new GBC(0, 0).insets(0, 0, 0, 0));
        panel.add((Component)lb1, new GBC(1, 0).insets(0, 0, 0, 0));
        panel.add((Component)sharedLabel, new GBC(2, 0).insets(0, 0, 0, 0));
        panel.add((Component)lb2, new GBC(3, 0).insets(0, 0, 0, 0));
        return panel;
    }
}

